// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing gateway target.
func (c *Client) UpdateGatewayTarget(ctx context.Context, params *UpdateGatewayTargetInput, optFns ...func(*Options)) (*UpdateGatewayTargetOutput, error) {
	if params == nil {
		params = &UpdateGatewayTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGatewayTarget", params, optFns, c.addOperationUpdateGatewayTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGatewayTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGatewayTargetInput struct {

	// The unique identifier of the gateway associated with the target.
	//
	// This member is required.
	GatewayIdentifier *string

	// The updated name for the gateway target.
	//
	// This member is required.
	Name *string

	// The configuration for a gateway target. This structure defines how the gateway
	// connects to and interacts with the target endpoint.
	//
	// This member is required.
	TargetConfiguration types.TargetConfiguration

	// The unique identifier of the gateway target to update.
	//
	// This member is required.
	TargetId *string

	// The updated credential provider configurations for the gateway target.
	CredentialProviderConfigurations []types.CredentialProviderConfiguration

	// The updated description for the gateway target.
	Description *string

	noSmithyDocumentSerde
}

type UpdateGatewayTargetOutput struct {

	// The timestamp when the gateway target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The updated credential provider configurations for the gateway target.
	//
	// This member is required.
	CredentialProviderConfigurations []types.CredentialProviderConfiguration

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// This member is required.
	GatewayArn *string

	// The updated name of the gateway target.
	//
	// This member is required.
	Name *string

	// The current status of the updated gateway target.
	//
	// This member is required.
	Status types.TargetStatus

	// The configuration for a gateway target. This structure defines how the gateway
	// connects to and interacts with the target endpoint.
	//
	// This member is required.
	TargetConfiguration types.TargetConfiguration

	// The unique identifier of the updated gateway target.
	//
	// This member is required.
	TargetId *string

	// The timestamp when the gateway target was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The updated description of the gateway target.
	Description *string

	// The date and time at which the targets were last synchronized.
	LastSynchronizedAt *time.Time

	// The reasons for the current status of the updated gateway target.
	StatusReasons []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGatewayTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateGatewayTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateGatewayTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGatewayTarget"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateGatewayTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGatewayTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGatewayTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGatewayTarget",
	}
}
