// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details about a specific flow execution, including its status, start
// and end times, and any errors that occurred during execution.
func (c *Client) GetFlowExecution(ctx context.Context, params *GetFlowExecutionInput, optFns ...func(*Options)) (*GetFlowExecutionOutput, error) {
	if params == nil {
		params = &GetFlowExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFlowExecution", params, optFns, c.addOperationGetFlowExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFlowExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFlowExecutionInput struct {

	// The unique identifier of the flow execution to retrieve.
	//
	// This member is required.
	ExecutionIdentifier *string

	// The unique identifier of the flow alias used for the execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	noSmithyDocumentSerde
}

type GetFlowExecutionOutput struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
	//
	// This member is required.
	ExecutionArn *string

	// The unique identifier of the flow alias used for the execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	// The version of the flow used for the execution.
	//
	// This member is required.
	FlowVersion *string

	// The timestamp when the flow execution started.
	//
	// This member is required.
	StartedAt *time.Time

	// The current status of the flow execution.
	//
	// Flow executions time out after 24 hours.
	//
	// This member is required.
	Status types.FlowExecutionStatus

	// The timestamp when the flow execution ended. This field is only populated when
	// the execution has completed, failed, timed out, or been aborted.
	EndedAt *time.Time

	// A list of errors that occurred during the flow execution. Each error includes
	// an error code, message, and the node where the error occurred, if applicable.
	Errors []types.FlowExecutionError

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFlowExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFlowExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFlowExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFlowExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFlowExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFlowExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFlowExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFlowExecution",
	}
}
