// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Reranks the relevance of sources based on queries. For more information, see [Improve the relevance of query responses with a reranker model].
//
// [Improve the relevance of query responses with a reranker model]: https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html
func (c *Client) Rerank(ctx context.Context, params *RerankInput, optFns ...func(*Options)) (*RerankOutput, error) {
	if params == nil {
		params = &RerankInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Rerank", params, optFns, c.addOperationRerankMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RerankOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RerankInput struct {

	// An array of objects, each of which contains information about a query to submit
	// to the reranker model.
	//
	// This member is required.
	Queries []types.RerankQuery

	// Contains configurations for reranking.
	//
	// This member is required.
	RerankingConfiguration *types.RerankingConfiguration

	// An array of objects, each of which contains information about the sources to
	// rerank.
	//
	// This member is required.
	Sources []types.RerankSource

	// If the total number of results was greater than could fit in a response, a
	// token is returned in the nextToken field. You can enter that token in this
	// field to return the next batch of results.
	NextToken *string

	noSmithyDocumentSerde
}

type RerankOutput struct {

	// An array of objects, each of which contains information about the results of
	// reranking.
	//
	// This member is required.
	Results []types.RerankResult

	// If the total number of results is greater than can fit in the response, use
	// this token in the nextToken field when making another request to return the
	// next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRerankMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRerank{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRerank{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Rerank"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRerankValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRerank(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// RerankPaginatorOptions is the paginator options for Rerank
type RerankPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// RerankPaginator is a paginator for Rerank
type RerankPaginator struct {
	options   RerankPaginatorOptions
	client    RerankAPIClient
	params    *RerankInput
	nextToken *string
	firstPage bool
}

// NewRerankPaginator returns a new RerankPaginator
func NewRerankPaginator(client RerankAPIClient, params *RerankInput, optFns ...func(*RerankPaginatorOptions)) *RerankPaginator {
	if params == nil {
		params = &RerankInput{}
	}

	options := RerankPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &RerankPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *RerankPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next Rerank page.
func (p *RerankPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*RerankOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.Rerank(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// RerankAPIClient is a client that implements the Rerank operation.
type RerankAPIClient interface {
	Rerank(context.Context, *RerankInput, ...func(*Options)) (*RerankOutput, error)
}

var _ RerankAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opRerank(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Rerank",
	}
}
