// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Config containing asset processing related knobs for all modalities
type AssetProcessingConfiguration struct {

	// Video asset processing configuration
	Video *VideoAssetProcessingConfiguration

	noSmithyDocumentSerde
}

// Structure for single blueprint entity.
type Blueprint struct {

	// Arn of blueprint.
	//
	// This member is required.
	BlueprintArn *string

	// Stage of blueprint.
	Stage BlueprintStage

	// Version of blueprint.
	Version *string

	noSmithyDocumentSerde
}

// Data automation configuration.
type DataAutomationConfiguration struct {

	// Data automation project arn.
	//
	// This member is required.
	DataAutomationProjectArn *string

	// Data automation stage.
	Stage DataAutomationStage

	noSmithyDocumentSerde
}

// Encryption configuration.
type EncryptionConfiguration struct {

	// Customer KMS key used for encryption
	//
	// This member is required.
	KmsKeyId *string

	// KMS encryption context.
	KmsEncryptionContext map[string]string

	noSmithyDocumentSerde
}

// Event bridge configuration.
type EventBridgeConfiguration struct {

	// Event bridge flag.
	//
	// This member is required.
	EventBridgeEnabled *bool

	noSmithyDocumentSerde
}

// Input configuration.
type InputConfiguration struct {

	// S3 uri.
	//
	// This member is required.
	S3Uri *string

	// Asset processing configuration
	AssetProcessingConfiguration *AssetProcessingConfiguration

	noSmithyDocumentSerde
}

// Notification configuration.
type NotificationConfiguration struct {

	// Event bridge configuration.
	//
	// This member is required.
	EventBridgeConfiguration *EventBridgeConfiguration

	noSmithyDocumentSerde
}

// Output configuration.
type OutputConfiguration struct {

	// S3 uri.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Results for an output segment
type OutputSegment struct {

	// Custom output response
	CustomOutput *string

	// Status of blueprint match
	CustomOutputStatus CustomOutputStatus

	// Standard output response
	StandardOutput *string

	noSmithyDocumentSerde
}

// Input configuration for synchronous API
type SyncInputConfiguration struct {

	// Input data as bytes
	Bytes []byte

	// S3 URI of the input data
	S3Uri *string

	noSmithyDocumentSerde
}

// Key value pair of a tag
type Tag struct {

	// Defines the context of the tag.
	//
	// This member is required.
	Key *string

	// Defines the value within the context. e.g. <key=reason, value=training>.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Timestamp segment
type TimestampSegment struct {

	// End timestamp in milliseconds
	//
	// This member is required.
	EndTimeMillis *int64

	// Start timestamp in milliseconds
	//
	// This member is required.
	StartTimeMillis *int64

	noSmithyDocumentSerde
}

// Video asset processing configuration
type VideoAssetProcessingConfiguration struct {

	// Delimits the segment of the input that will be processed
	SegmentConfiguration VideoSegmentConfiguration

	noSmithyDocumentSerde
}

// Delimits the segment of the input that will be processed
//
// The following types satisfy this interface:
//
//	VideoSegmentConfigurationMemberTimestampSegment
type VideoSegmentConfiguration interface {
	isVideoSegmentConfiguration()
}

// Timestamp segment
type VideoSegmentConfigurationMemberTimestampSegment struct {
	Value TimestampSegment

	noSmithyDocumentSerde
}

func (*VideoSegmentConfigurationMemberTimestampSegment) isVideoSegmentConfiguration() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isVideoSegmentConfiguration() {}
