// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomationruntime

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpGetDataAutomationStatus struct {
}

func (*validateOpGetDataAutomationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataAutomationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataAutomationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataAutomationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeDataAutomationAsync struct {
}

func (*validateOpInvokeDataAutomationAsync) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeDataAutomationAsync) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeDataAutomationAsyncInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeDataAutomationAsyncInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeDataAutomation struct {
}

func (*validateOpInvokeDataAutomation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeDataAutomation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeDataAutomationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeDataAutomationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpGetDataAutomationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataAutomationStatus{}, middleware.After)
}

func addOpInvokeDataAutomationAsyncValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeDataAutomationAsync{}, middleware.After)
}

func addOpInvokeDataAutomationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeDataAutomation{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateAssetProcessingConfiguration(v *types.AssetProcessingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetProcessingConfiguration"}
	if v.Video != nil {
		if err := validateVideoAssetProcessingConfiguration(v.Video); err != nil {
			invalidParams.AddNested("Video", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBlueprint(v *types.Blueprint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Blueprint"}
	if v.BlueprintArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BlueprintArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBlueprintList(v []types.Blueprint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BlueprintList"}
	for i := range v {
		if err := validateBlueprint(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDataAutomationConfiguration(v *types.DataAutomationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DataAutomationConfiguration"}
	if v.DataAutomationProjectArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataAutomationProjectArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEncryptionConfiguration(v *types.EncryptionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionConfiguration"}
	if v.KmsKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEventBridgeConfiguration(v *types.EventBridgeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EventBridgeConfiguration"}
	if v.EventBridgeEnabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventBridgeEnabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputConfiguration(v *types.InputConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputConfiguration"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if v.AssetProcessingConfiguration != nil {
		if err := validateAssetProcessingConfiguration(v.AssetProcessingConfiguration); err != nil {
			invalidParams.AddNested("AssetProcessingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationConfiguration(v *types.NotificationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationConfiguration"}
	if v.EventBridgeConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventBridgeConfiguration"))
	} else if v.EventBridgeConfiguration != nil {
		if err := validateEventBridgeConfiguration(v.EventBridgeConfiguration); err != nil {
			invalidParams.AddNested("EventBridgeConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputConfiguration(v *types.OutputConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputConfiguration"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTimestampSegment(v *types.TimestampSegment) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TimestampSegment"}
	if v.StartTimeMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTimeMillis"))
	}
	if v.EndTimeMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTimeMillis"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVideoAssetProcessingConfiguration(v *types.VideoAssetProcessingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VideoAssetProcessingConfiguration"}
	if v.SegmentConfiguration != nil {
		if err := validateVideoSegmentConfiguration(v.SegmentConfiguration); err != nil {
			invalidParams.AddNested("SegmentConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVideoSegmentConfiguration(v types.VideoSegmentConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VideoSegmentConfiguration"}
	switch uv := v.(type) {
	case *types.VideoSegmentConfigurationMemberTimestampSegment:
		if err := validateTimestampSegment(&uv.Value); err != nil {
			invalidParams.AddNested("[timestampSegment]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataAutomationStatusInput(v *GetDataAutomationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataAutomationStatusInput"}
	if v.InvocationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvocationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeDataAutomationAsyncInput(v *InvokeDataAutomationAsyncInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeDataAutomationAsyncInput"}
	if v.InputConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfiguration"))
	} else if v.InputConfiguration != nil {
		if err := validateInputConfiguration(v.InputConfiguration); err != nil {
			invalidParams.AddNested("InputConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputConfiguration"))
	} else if v.OutputConfiguration != nil {
		if err := validateOutputConfiguration(v.OutputConfiguration); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataAutomationConfiguration != nil {
		if err := validateDataAutomationConfiguration(v.DataAutomationConfiguration); err != nil {
			invalidParams.AddNested("DataAutomationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.NotificationConfiguration != nil {
		if err := validateNotificationConfiguration(v.NotificationConfiguration); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Blueprints != nil {
		if err := validateBlueprintList(v.Blueprints); err != nil {
			invalidParams.AddNested("Blueprints", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataAutomationProfileArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataAutomationProfileArn"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeDataAutomationInput(v *InvokeDataAutomationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeDataAutomationInput"}
	if v.InputConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfiguration"))
	}
	if v.DataAutomationConfiguration != nil {
		if err := validateDataAutomationConfiguration(v.DataAutomationConfiguration); err != nil {
			invalidParams.AddNested("DataAutomationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Blueprints != nil {
		if err := validateBlueprintList(v.Blueprints); err != nil {
			invalidParams.AddNested("Blueprints", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataAutomationProfileArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataAutomationProfileArn"))
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
