// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/bedrockruntime/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpApplyGuardrail struct {
}

func (*awsRestjson1_serializeOpApplyGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpApplyGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ApplyGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrail/{guardrailIdentifier}/version/{guardrailVersion}/apply")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsApplyGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentApplyGuardrailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsApplyGuardrailInput(v *ApplyGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	if v.GuardrailVersion == nil || len(*v.GuardrailVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailVersion must not be empty")}
	}
	if v.GuardrailVersion != nil {
		if err := encoder.SetURI("guardrailVersion").String(*v.GuardrailVersion); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentApplyGuardrailInput(v *ApplyGuardrailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentGuardrailContentBlockList(v.Content, ok); err != nil {
			return err
		}
	}

	if len(v.OutputScope) > 0 {
		ok := object.Key("outputScope")
		ok.String(string(v.OutputScope))
	}

	if len(v.Source) > 0 {
		ok := object.Key("source")
		ok.String(string(v.Source))
	}

	return nil
}

type awsRestjson1_serializeOpConverse struct {
}

func (*awsRestjson1_serializeOpConverse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConverse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConverseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/converse")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsConverseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentConverseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConverseInput(v *ConverseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentConverseInput(v *ConverseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalModelRequestFields != nil {
		ok := object.Key("additionalModelRequestFields")
		if err := awsRestjson1_serializeDocumentDocument(v.AdditionalModelRequestFields, ok); err != nil {
			return err
		}
	}

	if v.AdditionalModelResponseFieldPaths != nil {
		ok := object.Key("additionalModelResponseFieldPaths")
		if err := awsRestjson1_serializeDocumentAdditionalModelResponseFieldPaths(v.AdditionalModelResponseFieldPaths, ok); err != nil {
			return err
		}
	}

	if v.GuardrailConfig != nil {
		ok := object.Key("guardrailConfig")
		if err := awsRestjson1_serializeDocumentGuardrailConfiguration(v.GuardrailConfig, ok); err != nil {
			return err
		}
	}

	if v.InferenceConfig != nil {
		ok := object.Key("inferenceConfig")
		if err := awsRestjson1_serializeDocumentInferenceConfiguration(v.InferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.PerformanceConfig != nil {
		ok := object.Key("performanceConfig")
		if err := awsRestjson1_serializeDocumentPerformanceConfiguration(v.PerformanceConfig, ok); err != nil {
			return err
		}
	}

	if v.PromptVariables != nil {
		ok := object.Key("promptVariables")
		if err := awsRestjson1_serializeDocumentPromptVariableMap(v.PromptVariables, ok); err != nil {
			return err
		}
	}

	if v.RequestMetadata != nil {
		ok := object.Key("requestMetadata")
		if err := awsRestjson1_serializeDocumentRequestMetadata(v.RequestMetadata, ok); err != nil {
			return err
		}
	}

	if v.ServiceTier != nil {
		ok := object.Key("serviceTier")
		if err := awsRestjson1_serializeDocumentServiceTier(v.ServiceTier, ok); err != nil {
			return err
		}
	}

	if v.System != nil {
		ok := object.Key("system")
		if err := awsRestjson1_serializeDocumentSystemContentBlocks(v.System, ok); err != nil {
			return err
		}
	}

	if v.ToolConfig != nil {
		ok := object.Key("toolConfig")
		if err := awsRestjson1_serializeDocumentToolConfiguration(v.ToolConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpConverseStream struct {
}

func (*awsRestjson1_serializeOpConverseStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConverseStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConverseStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/converse-stream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsConverseStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentConverseStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConverseStreamInput(v *ConverseStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentConverseStreamInput(v *ConverseStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalModelRequestFields != nil {
		ok := object.Key("additionalModelRequestFields")
		if err := awsRestjson1_serializeDocumentDocument(v.AdditionalModelRequestFields, ok); err != nil {
			return err
		}
	}

	if v.AdditionalModelResponseFieldPaths != nil {
		ok := object.Key("additionalModelResponseFieldPaths")
		if err := awsRestjson1_serializeDocumentAdditionalModelResponseFieldPaths(v.AdditionalModelResponseFieldPaths, ok); err != nil {
			return err
		}
	}

	if v.GuardrailConfig != nil {
		ok := object.Key("guardrailConfig")
		if err := awsRestjson1_serializeDocumentGuardrailStreamConfiguration(v.GuardrailConfig, ok); err != nil {
			return err
		}
	}

	if v.InferenceConfig != nil {
		ok := object.Key("inferenceConfig")
		if err := awsRestjson1_serializeDocumentInferenceConfiguration(v.InferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.PerformanceConfig != nil {
		ok := object.Key("performanceConfig")
		if err := awsRestjson1_serializeDocumentPerformanceConfiguration(v.PerformanceConfig, ok); err != nil {
			return err
		}
	}

	if v.PromptVariables != nil {
		ok := object.Key("promptVariables")
		if err := awsRestjson1_serializeDocumentPromptVariableMap(v.PromptVariables, ok); err != nil {
			return err
		}
	}

	if v.RequestMetadata != nil {
		ok := object.Key("requestMetadata")
		if err := awsRestjson1_serializeDocumentRequestMetadata(v.RequestMetadata, ok); err != nil {
			return err
		}
	}

	if v.ServiceTier != nil {
		ok := object.Key("serviceTier")
		if err := awsRestjson1_serializeDocumentServiceTier(v.ServiceTier, ok); err != nil {
			return err
		}
	}

	if v.System != nil {
		ok := object.Key("system")
		if err := awsRestjson1_serializeDocumentSystemContentBlocks(v.System, ok); err != nil {
			return err
		}
	}

	if v.ToolConfig != nil {
		ok := object.Key("toolConfig")
		if err := awsRestjson1_serializeDocumentToolConfiguration(v.ToolConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCountTokens struct {
}

func (*awsRestjson1_serializeOpCountTokens) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCountTokens) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CountTokensInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/count-tokens")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCountTokensInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCountTokensInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCountTokensInput(v *CountTokensInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCountTokensInput(v *CountTokensInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Input != nil {
		ok := object.Key("input")
		if err := awsRestjson1_serializeDocumentCountTokensInput(v.Input, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAsyncInvoke struct {
}

func (*awsRestjson1_serializeOpGetAsyncInvoke) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAsyncInvoke) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAsyncInvokeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/async-invoke/{invocationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAsyncInvokeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAsyncInvokeInput(v *GetAsyncInvokeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InvocationArn == nil || len(*v.InvocationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member invocationArn must not be empty")}
	}
	if v.InvocationArn != nil {
		if err := encoder.SetURI("invocationArn").String(*v.InvocationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpInvokeModel struct {
}

func (*awsRestjson1_serializeOpInvokeModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/invoke")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeModelInput(v *InvokeModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Accept != nil {
		locationName := "Accept"
		encoder.SetHeader(locationName).String(*v.Accept)
	}

	if v.ContentType != nil {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.GuardrailIdentifier != nil {
		locationName := "X-Amzn-Bedrock-Guardrailidentifier"
		encoder.SetHeader(locationName).String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil {
		locationName := "X-Amzn-Bedrock-Guardrailversion"
		encoder.SetHeader(locationName).String(*v.GuardrailVersion)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	if len(v.PerformanceConfigLatency) > 0 {
		locationName := "X-Amzn-Bedrock-Performanceconfig-Latency"
		encoder.SetHeader(locationName).String(string(v.PerformanceConfigLatency))
	}

	if len(v.ServiceTier) > 0 {
		locationName := "X-Amzn-Bedrock-Service-Tier"
		encoder.SetHeader(locationName).String(string(v.ServiceTier))
	}

	if len(v.Trace) > 0 {
		locationName := "X-Amzn-Bedrock-Trace"
		encoder.SetHeader(locationName).String(string(v.Trace))
	}

	return nil
}

type awsRestjson1_serializeOpInvokeModelWithResponseStream struct {
}

func (*awsRestjson1_serializeOpInvokeModelWithResponseStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeModelWithResponseStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeModelWithResponseStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model/{modelId}/invoke-with-response-stream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeModelWithResponseStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeModelWithResponseStreamInput(v *InvokeModelWithResponseStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Accept != nil {
		locationName := "X-Amzn-Bedrock-Accept"
		encoder.SetHeader(locationName).String(*v.Accept)
	}

	if v.ContentType != nil {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.GuardrailIdentifier != nil {
		locationName := "X-Amzn-Bedrock-Guardrailidentifier"
		encoder.SetHeader(locationName).String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil {
		locationName := "X-Amzn-Bedrock-Guardrailversion"
		encoder.SetHeader(locationName).String(*v.GuardrailVersion)
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("modelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	if len(v.PerformanceConfigLatency) > 0 {
		locationName := "X-Amzn-Bedrock-Performanceconfig-Latency"
		encoder.SetHeader(locationName).String(string(v.PerformanceConfigLatency))
	}

	if len(v.ServiceTier) > 0 {
		locationName := "X-Amzn-Bedrock-Service-Tier"
		encoder.SetHeader(locationName).String(string(v.ServiceTier))
	}

	if len(v.Trace) > 0 {
		locationName := "X-Amzn-Bedrock-Trace"
		encoder.SetHeader(locationName).String(string(v.Trace))
	}

	return nil
}

type awsRestjson1_serializeOpListAsyncInvokes struct {
}

func (*awsRestjson1_serializeOpListAsyncInvokes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAsyncInvokes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAsyncInvokesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/async-invoke")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAsyncInvokesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAsyncInvokesInput(v *ListAsyncInvokesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	if v.SubmitTimeAfter != nil {
		encoder.SetQuery("submitTimeAfter").String(smithytime.FormatDateTime(*v.SubmitTimeAfter))
	}

	if v.SubmitTimeBefore != nil {
		encoder.SetQuery("submitTimeBefore").String(smithytime.FormatDateTime(*v.SubmitTimeBefore))
	}

	return nil
}

type awsRestjson1_serializeOpStartAsyncInvoke struct {
}

func (*awsRestjson1_serializeOpStartAsyncInvoke) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAsyncInvoke) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAsyncInvokeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/async-invoke")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAsyncInvokeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAsyncInvokeInput(v *StartAsyncInvokeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAsyncInvokeInput(v *StartAsyncInvokeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ModelId != nil {
		ok := object.Key("modelId")
		ok.String(*v.ModelId)
	}

	if v.ModelInput != nil {
		ok := object.Key("modelInput")
		if err := awsRestjson1_serializeDocumentModelInputPayload(v.ModelInput, ok); err != nil {
			return err
		}
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentAsyncInvokeOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalModelResponseFieldPaths(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAnyToolChoice(v *types.AnyToolChoice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentAsyncInvokeOutputDataConfig(v types.AsyncInvokeOutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AsyncInvokeOutputDataConfigMemberS3OutputDataConfig:
		av := object.Key("s3OutputDataConfig")
		if err := awsRestjson1_serializeDocumentAsyncInvokeS3OutputDataConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAsyncInvokeS3OutputDataConfig(v *types.AsyncInvokeS3OutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketOwner != nil {
		ok := object.Key("bucketOwner")
		ok.String(*v.BucketOwner)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioBlock(v *types.AudioBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Error != nil {
		ok := object.Key("error")
		if err := awsRestjson1_serializeDocumentErrorBlock(v.Error, ok); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentAudioSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSource(v types.AudioSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AudioSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	case *types.AudioSourceMemberS3Location:
		av := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAutoToolChoice(v *types.AutoToolChoice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentCachePointBlock(v *types.CachePointBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentCitation(v *types.Citation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Location != nil {
		ok := object.Key("location")
		if err := awsRestjson1_serializeDocumentCitationLocation(v.Location, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("source")
		ok.String(*v.Source)
	}

	if v.SourceContent != nil {
		ok := object.Key("sourceContent")
		if err := awsRestjson1_serializeDocumentCitationSourceContentList(v.SourceContent, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentCitationGeneratedContent(v types.CitationGeneratedContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CitationGeneratedContentMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCitationGeneratedContentList(v []types.CitationGeneratedContent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentCitationGeneratedContent(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCitationLocation(v types.CitationLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CitationLocationMemberDocumentChar:
		av := object.Key("documentChar")
		if err := awsRestjson1_serializeDocumentDocumentCharLocation(&uv.Value, av); err != nil {
			return err
		}

	case *types.CitationLocationMemberDocumentChunk:
		av := object.Key("documentChunk")
		if err := awsRestjson1_serializeDocumentDocumentChunkLocation(&uv.Value, av); err != nil {
			return err
		}

	case *types.CitationLocationMemberDocumentPage:
		av := object.Key("documentPage")
		if err := awsRestjson1_serializeDocumentDocumentPageLocation(&uv.Value, av); err != nil {
			return err
		}

	case *types.CitationLocationMemberSearchResultLocation:
		av := object.Key("searchResultLocation")
		if err := awsRestjson1_serializeDocumentSearchResultLocation(&uv.Value, av); err != nil {
			return err
		}

	case *types.CitationLocationMemberWeb:
		av := object.Key("web")
		if err := awsRestjson1_serializeDocumentWebLocation(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCitations(v []types.Citation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCitation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCitationsConfig(v *types.CitationsConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentCitationsContentBlock(v *types.CitationsContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Citations != nil {
		ok := object.Key("citations")
		if err := awsRestjson1_serializeDocumentCitations(v.Citations, ok); err != nil {
			return err
		}
	}

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentCitationGeneratedContentList(v.Content, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCitationSourceContent(v types.CitationSourceContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CitationSourceContentMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCitationSourceContentList(v []types.CitationSourceContent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentCitationSourceContent(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentContentBlock(v types.ContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ContentBlockMemberAudio:
		av := object.Key("audio")
		if err := awsRestjson1_serializeDocumentAudioBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberCachePoint:
		av := object.Key("cachePoint")
		if err := awsRestjson1_serializeDocumentCachePointBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberCitationsContent:
		av := object.Key("citationsContent")
		if err := awsRestjson1_serializeDocumentCitationsContentBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberDocument:
		av := object.Key("document")
		if err := awsRestjson1_serializeDocumentDocumentBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberGuardContent:
		av := object.Key("guardContent")
		if err := awsRestjson1_serializeDocumentGuardrailConverseContentBlock(uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberImage:
		av := object.Key("image")
		if err := awsRestjson1_serializeDocumentImageBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberReasoningContent:
		av := object.Key("reasoningContent")
		if err := awsRestjson1_serializeDocumentReasoningContentBlock(uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberSearchResult:
		av := object.Key("searchResult")
		if err := awsRestjson1_serializeDocumentSearchResultBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	case *types.ContentBlockMemberToolResult:
		av := object.Key("toolResult")
		if err := awsRestjson1_serializeDocumentToolResultBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberToolUse:
		av := object.Key("toolUse")
		if err := awsRestjson1_serializeDocumentToolUseBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ContentBlockMemberVideo:
		av := object.Key("video")
		if err := awsRestjson1_serializeDocumentVideoBlock(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentContentBlocks(v []types.ContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentContentBlock(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConverseTokensRequest(v *types.ConverseTokensRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalModelRequestFields != nil {
		ok := object.Key("additionalModelRequestFields")
		if err := awsRestjson1_serializeDocumentDocument(v.AdditionalModelRequestFields, ok); err != nil {
			return err
		}
	}

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.System != nil {
		ok := object.Key("system")
		if err := awsRestjson1_serializeDocumentSystemContentBlocks(v.System, ok); err != nil {
			return err
		}
	}

	if v.ToolConfig != nil {
		ok := object.Key("toolConfig")
		if err := awsRestjson1_serializeDocumentToolConfiguration(v.ToolConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCountTokensInput(v types.CountTokensInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CountTokensInputMemberConverse:
		av := object.Key("converse")
		if err := awsRestjson1_serializeDocumentConverseTokensRequest(&uv.Value, av); err != nil {
			return err
		}

	case *types.CountTokensInputMemberInvokeModel:
		av := object.Key("invokeModel")
		if err := awsRestjson1_serializeDocumentInvokeModelTokensRequest(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentBlock(v *types.DocumentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Citations != nil {
		ok := object.Key("citations")
		if err := awsRestjson1_serializeDocumentCitationsConfig(v.Citations, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("context")
		ok.String(*v.Context)
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentDocumentSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentCharLocation(v *types.DocumentCharLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentIndex != nil {
		ok := object.Key("documentIndex")
		ok.Integer(*v.DocumentIndex)
	}

	if v.End != nil {
		ok := object.Key("end")
		ok.Integer(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.Integer(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentChunkLocation(v *types.DocumentChunkLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentIndex != nil {
		ok := object.Key("documentIndex")
		ok.Integer(*v.DocumentIndex)
	}

	if v.End != nil {
		ok := object.Key("end")
		ok.Integer(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.Integer(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentContentBlock(v types.DocumentContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentContentBlockMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentContentBlocks(v []types.DocumentContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDocumentContentBlock(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentPageLocation(v *types.DocumentPageLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentIndex != nil {
		ok := object.Key("documentIndex")
		ok.Integer(*v.DocumentIndex)
	}

	if v.End != nil {
		ok := object.Key("end")
		ok.Integer(*v.End)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.Integer(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentSource(v types.DocumentSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	case *types.DocumentSourceMemberContent:
		av := object.Key("content")
		if err := awsRestjson1_serializeDocumentDocumentContentBlocks(uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentSourceMemberS3Location:
		av := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentSourceMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentErrorBlock(v *types.ErrorBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("message")
		ok.String(*v.Message)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailConfiguration(v *types.GuardrailConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GuardrailIdentifier != nil {
		ok := object.Key("guardrailIdentifier")
		ok.String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil {
		ok := object.Key("guardrailVersion")
		ok.String(*v.GuardrailVersion)
	}

	if len(v.Trace) > 0 {
		ok := object.Key("trace")
		ok.String(string(v.Trace))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentBlock(v types.GuardrailContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GuardrailContentBlockMemberImage:
		av := object.Key("image")
		if err := awsRestjson1_serializeDocumentGuardrailImageBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.GuardrailContentBlockMemberText:
		av := object.Key("text")
		if err := awsRestjson1_serializeDocumentGuardrailTextBlock(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentBlockList(v []types.GuardrailContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentGuardrailContentBlock(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentQualifierList(v []types.GuardrailContentQualifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailConverseContentBlock(v types.GuardrailConverseContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GuardrailConverseContentBlockMemberImage:
		av := object.Key("image")
		if err := awsRestjson1_serializeDocumentGuardrailConverseImageBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.GuardrailConverseContentBlockMemberText:
		av := object.Key("text")
		if err := awsRestjson1_serializeDocumentGuardrailConverseTextBlock(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailConverseContentQualifierList(v []types.GuardrailConverseContentQualifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailConverseImageBlock(v *types.GuardrailConverseImageBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentGuardrailConverseImageSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailConverseImageSource(v types.GuardrailConverseImageSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GuardrailConverseImageSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailConverseTextBlock(v *types.GuardrailConverseTextBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Qualifiers != nil {
		ok := object.Key("qualifiers")
		if err := awsRestjson1_serializeDocumentGuardrailConverseContentQualifierList(v.Qualifiers, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailImageBlock(v *types.GuardrailImageBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentGuardrailImageSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailImageSource(v types.GuardrailImageSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.GuardrailImageSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailStreamConfiguration(v *types.GuardrailStreamConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GuardrailIdentifier != nil {
		ok := object.Key("guardrailIdentifier")
		ok.String(*v.GuardrailIdentifier)
	}

	if v.GuardrailVersion != nil {
		ok := object.Key("guardrailVersion")
		ok.String(*v.GuardrailVersion)
	}

	if len(v.StreamProcessingMode) > 0 {
		ok := object.Key("streamProcessingMode")
		ok.String(string(v.StreamProcessingMode))
	}

	if len(v.Trace) > 0 {
		ok := object.Key("trace")
		ok.String(string(v.Trace))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTextBlock(v *types.GuardrailTextBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Qualifiers != nil {
		ok := object.Key("qualifiers")
		if err := awsRestjson1_serializeDocumentGuardrailContentQualifierList(v.Qualifiers, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentImageBlock(v *types.ImageBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Error != nil {
		ok := object.Key("error")
		if err := awsRestjson1_serializeDocumentErrorBlock(v.Error, ok); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentImageSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageSource(v types.ImageSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ImageSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	case *types.ImageSourceMemberS3Location:
		av := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentInferenceConfiguration(v *types.InferenceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxTokens != nil {
		ok := object.Key("maxTokens")
		ok.Integer(*v.MaxTokens)
	}

	if v.StopSequences != nil {
		ok := object.Key("stopSequences")
		if err := awsRestjson1_serializeDocumentNonEmptyStringList(v.StopSequences, ok); err != nil {
			return err
		}
	}

	if v.Temperature != nil {
		ok := object.Key("temperature")
		switch {
		case math.IsNaN(float64(*v.Temperature)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Temperature), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Temperature), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Temperature)

		}
	}

	if v.TopP != nil {
		ok := object.Key("topP")
		switch {
		case math.IsNaN(float64(*v.TopP)):
			ok.String("NaN")

		case math.IsInf(float64(*v.TopP), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.TopP), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.TopP)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInvokeModelTokensRequest(v *types.InvokeModelTokensRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("body")
		ok.Base64EncodeBytes(v.Body)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentContentBlocks(v.Content, ok); err != nil {
			return err
		}
	}

	if len(v.Role) > 0 {
		ok := object.Key("role")
		ok.String(string(v.Role))
	}

	return nil
}

func awsRestjson1_serializeDocumentMessages(v []types.Message, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentModelInputPayload(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentNonEmptyStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPerformanceConfiguration(v *types.PerformanceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Latency) > 0 {
		ok := object.Key("latency")
		ok.String(string(v.Latency))
	}

	return nil
}

func awsRestjson1_serializeDocumentPromptVariableMap(v map[string]types.PromptVariableValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPromptVariableValues(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPromptVariableValues(v types.PromptVariableValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PromptVariableValuesMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentReasoningContentBlock(v types.ReasoningContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ReasoningContentBlockMemberReasoningText:
		av := object.Key("reasoningText")
		if err := awsRestjson1_serializeDocumentReasoningTextBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ReasoningContentBlockMemberRedactedContent:
		av := object.Key("redactedContent")
		av.Base64EncodeBytes(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentReasoningTextBlock(v *types.ReasoningTextBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Signature != nil {
		ok := object.Key("signature")
		ok.String(*v.Signature)
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestMetadata(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Location(v *types.S3Location, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketOwner != nil {
		ok := object.Key("bucketOwner")
		ok.String(*v.BucketOwner)
	}

	if v.Uri != nil {
		ok := object.Key("uri")
		ok.String(*v.Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchResultBlock(v *types.SearchResultBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Citations != nil {
		ok := object.Key("citations")
		if err := awsRestjson1_serializeDocumentCitationsConfig(v.Citations, ok); err != nil {
			return err
		}
	}

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentSearchResultContentBlocks(v.Content, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("source")
		ok.String(*v.Source)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchResultContentBlock(v *types.SearchResultContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchResultContentBlocks(v []types.SearchResultContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSearchResultContentBlock(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchResultLocation(v *types.SearchResultLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.End != nil {
		ok := object.Key("end")
		ok.Integer(*v.End)
	}

	if v.SearchResultIndex != nil {
		ok := object.Key("searchResultIndex")
		ok.Integer(*v.SearchResultIndex)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.Integer(*v.Start)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceTier(v *types.ServiceTier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentSpecificToolChoice(v *types.SpecificToolChoice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentSystemContentBlock(v types.SystemContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SystemContentBlockMemberCachePoint:
		av := object.Key("cachePoint")
		if err := awsRestjson1_serializeDocumentCachePointBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.SystemContentBlockMemberGuardContent:
		av := object.Key("guardContent")
		if err := awsRestjson1_serializeDocumentGuardrailConverseContentBlock(uv.Value, av); err != nil {
			return err
		}

	case *types.SystemContentBlockMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSystemContentBlocks(v []types.SystemContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentSystemContentBlock(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSystemTool(v *types.SystemTool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTool(v types.Tool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ToolMemberCachePoint:
		av := object.Key("cachePoint")
		if err := awsRestjson1_serializeDocumentCachePointBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolMemberSystemTool:
		av := object.Key("systemTool")
		if err := awsRestjson1_serializeDocumentSystemTool(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolMemberToolSpec:
		av := object.Key("toolSpec")
		if err := awsRestjson1_serializeDocumentToolSpecification(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentToolChoice(v types.ToolChoice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ToolChoiceMemberAny:
		av := object.Key("any")
		if err := awsRestjson1_serializeDocumentAnyToolChoice(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolChoiceMemberAuto:
		av := object.Key("auto")
		if err := awsRestjson1_serializeDocumentAutoToolChoice(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolChoiceMemberTool:
		av := object.Key("tool")
		if err := awsRestjson1_serializeDocumentSpecificToolChoice(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentToolConfiguration(v *types.ToolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ToolChoice != nil {
		ok := object.Key("toolChoice")
		if err := awsRestjson1_serializeDocumentToolChoice(v.ToolChoice, ok); err != nil {
			return err
		}
	}

	if v.Tools != nil {
		ok := object.Key("tools")
		if err := awsRestjson1_serializeDocumentTools(v.Tools, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentToolInputSchema(v types.ToolInputSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ToolInputSchemaMemberJson:
		av := object.Key("json")
		if err := awsRestjson1_serializeDocumentDocument(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentToolResultBlock(v *types.ToolResultBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentToolResultContentBlocks(v.Content, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.ToolUseId != nil {
		ok := object.Key("toolUseId")
		ok.String(*v.ToolUseId)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentToolResultContentBlock(v types.ToolResultContentBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ToolResultContentBlockMemberDocument:
		av := object.Key("document")
		if err := awsRestjson1_serializeDocumentDocumentBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolResultContentBlockMemberImage:
		av := object.Key("image")
		if err := awsRestjson1_serializeDocumentImageBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolResultContentBlockMemberJson:
		av := object.Key("json")
		if err := awsRestjson1_serializeDocumentDocument(uv.Value, av); err != nil {
			return err
		}

	case *types.ToolResultContentBlockMemberSearchResult:
		av := object.Key("searchResult")
		if err := awsRestjson1_serializeDocumentSearchResultBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ToolResultContentBlockMemberText:
		av := object.Key("text")
		av.String(uv.Value)

	case *types.ToolResultContentBlockMemberVideo:
		av := object.Key("video")
		if err := awsRestjson1_serializeDocumentVideoBlock(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentToolResultContentBlocks(v []types.ToolResultContentBlock, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentToolResultContentBlock(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTools(v []types.Tool, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentTool(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentToolSpecification(v *types.ToolSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InputSchema != nil {
		ok := object.Key("inputSchema")
		if err := awsRestjson1_serializeDocumentToolInputSchema(v.InputSchema, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentToolUseBlock(v *types.ToolUseBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Input != nil {
		ok := object.Key("input")
		if err := awsRestjson1_serializeDocumentDocument(v.Input, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ToolUseId != nil {
		ok := object.Key("toolUseId")
		ok.String(*v.ToolUseId)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoBlock(v *types.VideoBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentVideoSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSource(v types.VideoSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VideoSourceMemberBytes:
		av := object.Key("bytes")
		av.Base64EncodeBytes(uv.Value)

	case *types.VideoSourceMemberS3Location:
		av := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3Location(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentWebLocation(v *types.WebLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("domain")
		ok.String(*v.Domain)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocument(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}
