// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the configured model algorithm associations in a
// collaboration.
func (c *Client) ListCollaborationConfiguredModelAlgorithmAssociations(ctx context.Context, params *ListCollaborationConfiguredModelAlgorithmAssociationsInput, optFns ...func(*Options)) (*ListCollaborationConfiguredModelAlgorithmAssociationsOutput, error) {
	if params == nil {
		params = &ListCollaborationConfiguredModelAlgorithmAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCollaborationConfiguredModelAlgorithmAssociations", params, optFns, c.addOperationListCollaborationConfiguredModelAlgorithmAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCollaborationConfiguredModelAlgorithmAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCollaborationConfiguredModelAlgorithmAssociationsInput struct {

	// The collaboration ID of the collaboration that contains the configured model
	// algorithm associations that you are interested in.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCollaborationConfiguredModelAlgorithmAssociationsOutput struct {

	// The configured model algorithm associations that belong to this collaboration.
	//
	// This member is required.
	CollaborationConfiguredModelAlgorithmAssociations []types.CollaborationConfiguredModelAlgorithmAssociationSummary

	// The token value used to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCollaborationConfiguredModelAlgorithmAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCollaborationConfiguredModelAlgorithmAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCollaborationConfiguredModelAlgorithmAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCollaborationConfiguredModelAlgorithmAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCollaborationConfiguredModelAlgorithmAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCollaborationConfiguredModelAlgorithmAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCollaborationConfiguredModelAlgorithmAssociationsPaginatorOptions is the
// paginator options for ListCollaborationConfiguredModelAlgorithmAssociations
type ListCollaborationConfiguredModelAlgorithmAssociationsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCollaborationConfiguredModelAlgorithmAssociationsPaginator is a paginator
// for ListCollaborationConfiguredModelAlgorithmAssociations
type ListCollaborationConfiguredModelAlgorithmAssociationsPaginator struct {
	options   ListCollaborationConfiguredModelAlgorithmAssociationsPaginatorOptions
	client    ListCollaborationConfiguredModelAlgorithmAssociationsAPIClient
	params    *ListCollaborationConfiguredModelAlgorithmAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListCollaborationConfiguredModelAlgorithmAssociationsPaginator returns a new
// ListCollaborationConfiguredModelAlgorithmAssociationsPaginator
func NewListCollaborationConfiguredModelAlgorithmAssociationsPaginator(client ListCollaborationConfiguredModelAlgorithmAssociationsAPIClient, params *ListCollaborationConfiguredModelAlgorithmAssociationsInput, optFns ...func(*ListCollaborationConfiguredModelAlgorithmAssociationsPaginatorOptions)) *ListCollaborationConfiguredModelAlgorithmAssociationsPaginator {
	if params == nil {
		params = &ListCollaborationConfiguredModelAlgorithmAssociationsInput{}
	}

	options := ListCollaborationConfiguredModelAlgorithmAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCollaborationConfiguredModelAlgorithmAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCollaborationConfiguredModelAlgorithmAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next
// ListCollaborationConfiguredModelAlgorithmAssociations page.
func (p *ListCollaborationConfiguredModelAlgorithmAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCollaborationConfiguredModelAlgorithmAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCollaborationConfiguredModelAlgorithmAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCollaborationConfiguredModelAlgorithmAssociationsAPIClient is a client that
// implements the ListCollaborationConfiguredModelAlgorithmAssociations operation.
type ListCollaborationConfiguredModelAlgorithmAssociationsAPIClient interface {
	ListCollaborationConfiguredModelAlgorithmAssociations(context.Context, *ListCollaborationConfiguredModelAlgorithmAssociationsInput, ...func(*Options)) (*ListCollaborationConfiguredModelAlgorithmAssociationsOutput, error)
}

var _ ListCollaborationConfiguredModelAlgorithmAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCollaborationConfiguredModelAlgorithmAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCollaborationConfiguredModelAlgorithmAssociations",
	}
}
