// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the export jobs for a trained model in a collaboration.
func (c *Client) ListCollaborationTrainedModelExportJobs(ctx context.Context, params *ListCollaborationTrainedModelExportJobsInput, optFns ...func(*Options)) (*ListCollaborationTrainedModelExportJobsOutput, error) {
	if params == nil {
		params = &ListCollaborationTrainedModelExportJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCollaborationTrainedModelExportJobs", params, optFns, c.addOperationListCollaborationTrainedModelExportJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCollaborationTrainedModelExportJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCollaborationTrainedModelExportJobsInput struct {

	// The collaboration ID of the collaboration that contains the trained model
	// export jobs that you are interested in.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The Amazon Resource Name (ARN) of the trained model that was used to create the
	// export jobs that you are interested in.
	//
	// This member is required.
	TrainedModelArn *string

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	// The version identifier of the trained model to filter export jobs by. When
	// specified, only export jobs for this specific version of the trained model are
	// returned.
	TrainedModelVersionIdentifier *string

	noSmithyDocumentSerde
}

type ListCollaborationTrainedModelExportJobsOutput struct {

	// The exports jobs that exist for the requested trained model in the requested
	// collaboration.
	//
	// This member is required.
	CollaborationTrainedModelExportJobs []types.CollaborationTrainedModelExportJobSummary

	// The token value used to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCollaborationTrainedModelExportJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCollaborationTrainedModelExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCollaborationTrainedModelExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCollaborationTrainedModelExportJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCollaborationTrainedModelExportJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCollaborationTrainedModelExportJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCollaborationTrainedModelExportJobsPaginatorOptions is the paginator
// options for ListCollaborationTrainedModelExportJobs
type ListCollaborationTrainedModelExportJobsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCollaborationTrainedModelExportJobsPaginator is a paginator for
// ListCollaborationTrainedModelExportJobs
type ListCollaborationTrainedModelExportJobsPaginator struct {
	options   ListCollaborationTrainedModelExportJobsPaginatorOptions
	client    ListCollaborationTrainedModelExportJobsAPIClient
	params    *ListCollaborationTrainedModelExportJobsInput
	nextToken *string
	firstPage bool
}

// NewListCollaborationTrainedModelExportJobsPaginator returns a new
// ListCollaborationTrainedModelExportJobsPaginator
func NewListCollaborationTrainedModelExportJobsPaginator(client ListCollaborationTrainedModelExportJobsAPIClient, params *ListCollaborationTrainedModelExportJobsInput, optFns ...func(*ListCollaborationTrainedModelExportJobsPaginatorOptions)) *ListCollaborationTrainedModelExportJobsPaginator {
	if params == nil {
		params = &ListCollaborationTrainedModelExportJobsInput{}
	}

	options := ListCollaborationTrainedModelExportJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCollaborationTrainedModelExportJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCollaborationTrainedModelExportJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCollaborationTrainedModelExportJobs page.
func (p *ListCollaborationTrainedModelExportJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCollaborationTrainedModelExportJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCollaborationTrainedModelExportJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCollaborationTrainedModelExportJobsAPIClient is a client that implements
// the ListCollaborationTrainedModelExportJobs operation.
type ListCollaborationTrainedModelExportJobsAPIClient interface {
	ListCollaborationTrainedModelExportJobs(context.Context, *ListCollaborationTrainedModelExportJobsInput, ...func(*Options)) (*ListCollaborationTrainedModelExportJobsOutput, error)
}

var _ ListCollaborationTrainedModelExportJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCollaborationTrainedModelExportJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCollaborationTrainedModelExportJobs",
	}
}
