// Code generated by smithy-go-codegen DO NOT EDIT.

package codebuild

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codebuild/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of sandboxes.
func (c *Client) ListSandboxes(ctx context.Context, params *ListSandboxesInput, optFns ...func(*Options)) (*ListSandboxesOutput, error) {
	if params == nil {
		params = &ListSandboxesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSandboxes", params, optFns, c.addOperationListSandboxesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSandboxesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSandboxesInput struct {

	// The maximum number of sandbox records to be retrieved.
	MaxResults *int32

	// The next token, if any, to get paginated results. You will get this value from
	// previous execution of list sandboxes.
	NextToken *string

	// The order in which sandbox records should be retrieved.
	SortOrder types.SortOrderType

	noSmithyDocumentSerde
}

type ListSandboxesOutput struct {

	// Information about the requested sandbox IDs.
	Ids []string

	// Information about the next token to get paginated results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSandboxesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListSandboxes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListSandboxes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSandboxes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSandboxes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSandboxesPaginatorOptions is the paginator options for ListSandboxes
type ListSandboxesPaginatorOptions struct {
	// The maximum number of sandbox records to be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSandboxesPaginator is a paginator for ListSandboxes
type ListSandboxesPaginator struct {
	options   ListSandboxesPaginatorOptions
	client    ListSandboxesAPIClient
	params    *ListSandboxesInput
	nextToken *string
	firstPage bool
}

// NewListSandboxesPaginator returns a new ListSandboxesPaginator
func NewListSandboxesPaginator(client ListSandboxesAPIClient, params *ListSandboxesInput, optFns ...func(*ListSandboxesPaginatorOptions)) *ListSandboxesPaginator {
	if params == nil {
		params = &ListSandboxesInput{}
	}

	options := ListSandboxesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSandboxesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSandboxesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSandboxes page.
func (p *ListSandboxesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSandboxesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSandboxes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSandboxesAPIClient is a client that implements the ListSandboxes operation.
type ListSandboxesAPIClient interface {
	ListSandboxes(context.Context, *ListSandboxesInput, ...func(*Options)) (*ListSandboxesOutput, error)
}

var _ ListSandboxesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSandboxes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSandboxes",
	}
}
