// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the rule executions that have occurred in a pipeline configured for
// conditions with rules.
func (c *Client) ListRuleExecutions(ctx context.Context, params *ListRuleExecutionsInput, optFns ...func(*Options)) (*ListRuleExecutionsOutput, error) {
	if params == nil {
		params = &ListRuleExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRuleExecutions", params, optFns, c.addOperationListRuleExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRuleExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRuleExecutionsInput struct {

	// The name of the pipeline for which you want to get execution summary
	// information.
	//
	// This member is required.
	PipelineName *string

	// Input information used to filter rule execution history.
	Filter *types.RuleExecutionFilter

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Pipeline
	// history is limited to the most recent 12 months, based on pipeline execution
	// start times. Default value is 100.
	MaxResults *int32

	// The token that was returned from the previous ListRuleExecutions call, which
	// can be used to return the next set of rule executions in the list.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRuleExecutionsOutput struct {

	// A token that can be used in the next ListRuleExecutions call. To view all items
	// in the list, continue to call this operation with each subsequent token until no
	// more nextToken values are returned.
	NextToken *string

	// Details about the output for listing rule executions.
	RuleExecutionDetails []types.RuleExecutionDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRuleExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListRuleExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListRuleExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRuleExecutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRuleExecutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRuleExecutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRuleExecutionsPaginatorOptions is the paginator options for
// ListRuleExecutions
type ListRuleExecutionsPaginatorOptions struct {
	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Pipeline
	// history is limited to the most recent 12 months, based on pipeline execution
	// start times. Default value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRuleExecutionsPaginator is a paginator for ListRuleExecutions
type ListRuleExecutionsPaginator struct {
	options   ListRuleExecutionsPaginatorOptions
	client    ListRuleExecutionsAPIClient
	params    *ListRuleExecutionsInput
	nextToken *string
	firstPage bool
}

// NewListRuleExecutionsPaginator returns a new ListRuleExecutionsPaginator
func NewListRuleExecutionsPaginator(client ListRuleExecutionsAPIClient, params *ListRuleExecutionsInput, optFns ...func(*ListRuleExecutionsPaginatorOptions)) *ListRuleExecutionsPaginator {
	if params == nil {
		params = &ListRuleExecutionsInput{}
	}

	options := ListRuleExecutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRuleExecutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRuleExecutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRuleExecutions page.
func (p *ListRuleExecutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRuleExecutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRuleExecutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRuleExecutionsAPIClient is a client that implements the ListRuleExecutions
// operation.
type ListRuleExecutionsAPIClient interface {
	ListRuleExecutions(context.Context, *ListRuleExecutionsInput, ...func(*Options)) (*ListRuleExecutionsOutput, error)
}

var _ ListRuleExecutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRuleExecutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRuleExecutions",
	}
}
