// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Given a refresh token, issues new ID, access, and optionally refresh tokens for
// the user who owns the submitted token. This operation issues a new refresh token
// and invalidates the original refresh token after an optional grace period when
// refresh token rotation is enabled. If refresh token rotation is disabled, issues
// new ID and access tokens only.
func (c *Client) GetTokensFromRefreshToken(ctx context.Context, params *GetTokensFromRefreshTokenInput, optFns ...func(*Options)) (*GetTokensFromRefreshTokenOutput, error) {
	if params == nil {
		params = &GetTokensFromRefreshTokenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTokensFromRefreshToken", params, optFns, c.addOperationGetTokensFromRefreshTokenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTokensFromRefreshTokenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTokensFromRefreshTokenInput struct {

	// The app client that issued the refresh token to the user who wants to request
	// new tokens.
	//
	// This member is required.
	ClientId *string

	// A valid refresh token that can authorize the request for new tokens. When
	// refresh token rotation is active in the requested app client, this token is
	// invalidated after the request is complete and after an optional grace period.
	//
	// This member is required.
	RefreshToken *string

	// A map of custom key-value pairs that you can provide as input for certain
	// custom workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool
	// triggers. When you use the GetTokensFromRefreshToken API action, Amazon Cognito
	// invokes the Lambda function the pre token generation trigger.
	//
	// For more information, see [Using Lambda triggers] in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, note that Amazon Cognito won't do
	// the following:
	//
	//   - Store the ClientMetadata value. This data is available only to Lambda
	//   triggers that are assigned to a user pool to support custom workflows. If your
	//   user pool configuration doesn't include triggers, the ClientMetadata parameter
	//   serves no purpose.
	//
	//   - Validate the ClientMetadata value.
	//
	//   - Encrypt the ClientMetadata value. Don't send sensitive information in this
	//   parameter.
	//
	// [Using Lambda triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
	ClientMetadata map[string]string

	// The client secret of the requested app client, if the client has a secret.
	ClientSecret *string

	// When you enable device remembering, Amazon Cognito issues a device key that you
	// can use for device authentication that bypasses multi-factor authentication
	// (MFA). To implement GetTokensFromRefreshToken in a user pool with device
	// remembering, you must capture the device key from the initial authentication
	// request. If your application doesn't provide the key of a registered device,
	// Amazon Cognito issues a new one. You must provide the confirmed device key in
	// this request if device remembering is enabled in your user pool.
	//
	// For more information about device remembering, see [Working with devices].
	//
	// [Working with devices]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html
	DeviceKey *string

	noSmithyDocumentSerde
}

type GetTokensFromRefreshTokenOutput struct {

	// The object that your application receives after authentication. Contains tokens
	// and information for device authentication.
	AuthenticationResult *types.AuthenticationResultType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTokensFromRefreshTokenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetTokensFromRefreshToken{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetTokensFromRefreshToken{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTokensFromRefreshToken"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetTokensFromRefreshTokenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTokensFromRefreshToken(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTokensFromRefreshToken(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTokensFromRefreshToken",
	}
}
