// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a preview of the recommended actions that match your Automation rule's
// configuration and criteria.
func (c *Client) ListAutomationRulePreview(ctx context.Context, params *ListAutomationRulePreviewInput, optFns ...func(*Options)) (*ListAutomationRulePreviewOutput, error) {
	if params == nil {
		params = &ListAutomationRulePreviewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomationRulePreview", params, optFns, c.addOperationListAutomationRulePreviewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomationRulePreviewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomationRulePreviewInput struct {

	//  The types of recommended actions to include in the preview.
	//
	// This member is required.
	RecommendedActionTypes []types.RecommendedActionType

	//  The type of rule.
	//
	// Only the management account or a delegated administrator can set the ruleType
	// to be OrganizationRule.
	//
	// This member is required.
	RuleType types.RuleType

	// A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time.
	Criteria *types.Criteria

	// The maximum number of automation rule preview results to return in a single
	// response. Valid range is 1-1000.
	MaxResults *int32

	// A token used for pagination to retrieve the next set of results when the
	// response is truncated.
	NextToken *string

	//  The organizational scope for the rule preview.
	OrganizationScope *types.OrganizationScope

	noSmithyDocumentSerde
}

type ListAutomationRulePreviewOutput struct {

	// A token used for pagination. If present, indicates there are more results
	// available and can be used in subsequent requests.
	NextToken *string

	//  The list of actions that would be taken based on the specified criteria.
	PreviewResults []types.PreviewResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomationRulePreviewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutomationRulePreview{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutomationRulePreview{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomationRulePreview"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomationRulePreviewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomationRulePreview(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomationRulePreviewPaginatorOptions is the paginator options for
// ListAutomationRulePreview
type ListAutomationRulePreviewPaginatorOptions struct {
	// The maximum number of automation rule preview results to return in a single
	// response. Valid range is 1-1000.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomationRulePreviewPaginator is a paginator for ListAutomationRulePreview
type ListAutomationRulePreviewPaginator struct {
	options   ListAutomationRulePreviewPaginatorOptions
	client    ListAutomationRulePreviewAPIClient
	params    *ListAutomationRulePreviewInput
	nextToken *string
	firstPage bool
}

// NewListAutomationRulePreviewPaginator returns a new
// ListAutomationRulePreviewPaginator
func NewListAutomationRulePreviewPaginator(client ListAutomationRulePreviewAPIClient, params *ListAutomationRulePreviewInput, optFns ...func(*ListAutomationRulePreviewPaginatorOptions)) *ListAutomationRulePreviewPaginator {
	if params == nil {
		params = &ListAutomationRulePreviewInput{}
	}

	options := ListAutomationRulePreviewPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomationRulePreviewPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomationRulePreviewPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomationRulePreview page.
func (p *ListAutomationRulePreviewPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomationRulePreviewOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomationRulePreview(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomationRulePreviewAPIClient is a client that implements the
// ListAutomationRulePreview operation.
type ListAutomationRulePreviewAPIClient interface {
	ListAutomationRulePreview(context.Context, *ListAutomationRulePreviewInput, ...func(*Options)) (*ListAutomationRulePreviewOutput, error)
}

var _ ListAutomationRulePreviewAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomationRulePreview(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomationRulePreview",
	}
}
