// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the automation rules that match specified filters.
func (c *Client) ListAutomationRules(ctx context.Context, params *ListAutomationRulesInput, optFns ...func(*Options)) (*ListAutomationRulesOutput, error) {
	if params == nil {
		params = &ListAutomationRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomationRules", params, optFns, c.addOperationListAutomationRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomationRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomationRulesInput struct {

	//  The filters to apply to the list of automation rules.
	Filters []types.Filter

	// The maximum number of automation rules to return in a single response. Valid
	// range is 1-1000.
	MaxResults *int32

	// A token used for pagination to retrieve the next set of results when the
	// response is truncated.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomationRulesOutput struct {

	//  The list of automation rules that match the specified criteria.
	AutomationRules []types.AutomationRule

	// A token used for pagination. If present, indicates there are more results
	// available and can be used in subsequent requests.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomationRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutomationRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutomationRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomationRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomationRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomationRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomationRulesPaginatorOptions is the paginator options for
// ListAutomationRules
type ListAutomationRulesPaginatorOptions struct {
	// The maximum number of automation rules to return in a single response. Valid
	// range is 1-1000.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomationRulesPaginator is a paginator for ListAutomationRules
type ListAutomationRulesPaginator struct {
	options   ListAutomationRulesPaginatorOptions
	client    ListAutomationRulesAPIClient
	params    *ListAutomationRulesInput
	nextToken *string
	firstPage bool
}

// NewListAutomationRulesPaginator returns a new ListAutomationRulesPaginator
func NewListAutomationRulesPaginator(client ListAutomationRulesAPIClient, params *ListAutomationRulesInput, optFns ...func(*ListAutomationRulesPaginatorOptions)) *ListAutomationRulesPaginator {
	if params == nil {
		params = &ListAutomationRulesInput{}
	}

	options := ListAutomationRulesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomationRulesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomationRulesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomationRules page.
func (p *ListAutomationRulesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomationRulesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomationRules(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomationRulesAPIClient is a client that implements the
// ListAutomationRules operation.
type ListAutomationRulesAPIClient interface {
	ListAutomationRules(context.Context, *ListAutomationRulesInput, ...func(*Options)) (*ListAutomationRulesOutput, error)
}

var _ ListAutomationRulesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomationRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomationRules",
	}
}
