// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

//	Contains information about an Amazon Web Services account's enrollment and
//
// association status with Compute Optimizer Automation.
type AccountInfo struct {

	//  The ID of the Amazon Web Services account.
	//
	// This member is required.
	AccountId *string

	// The timestamp when the account's Automation enrollment status was last updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	// Specifies whether the management account can create Automation rules that
	// implement optimization actions for this account.
	//
	// This member is required.
	OrganizationRuleMode OrganizationRuleMode

	//  The enrollment status of the account: Active, Inactive, Pending, or Failed.
	//
	// This member is required.
	Status EnrollmentStatus

	// The reason for the current Automation enrollment status.
	StatusReason *string

	noSmithyDocumentSerde
}

// Contains information about an automation event.
type AutomationEvent struct {

	//  The Amazon Web Services account ID associated with the automation event.
	AccountId *string

	//  The timestamp when the automation event completed.
	CompletedTimestamp *time.Time

	// The timestamp when the automation event was created.
	CreatedTimestamp *time.Time

	//  The estimated monthly cost savings associated with this automation event.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	//  A description of the automation event.
	EventDescription *string

	//  The unique identifier for the automation event.
	EventId *string

	//  The current status of the automation event.
	EventStatus EventStatus

	//  The reason for the current event status.
	EventStatusReason *string

	//  The type of automation event.
	EventType EventType

	//  The ID of the recommended action associated with this automation event.
	RecommendedActionId *string

	//  The Amazon Web Services Region where the automation event occurred.
	Region *string

	//  The Amazon Resource Name (ARN) of the resource affected by the automation
	// event.
	ResourceArn *string

	//  The ID of the resource affected by the automation event.
	ResourceId *string

	//  The type of resource affected by the automation event.
	ResourceType ResourceType

	//  The ID of the automation rule that triggered this event.
	RuleId *string

	noSmithyDocumentSerde
}

// A filter to apply when listing automation events.
type AutomationEventFilter struct {

	//  The name of the filter to apply.
	//
	// This member is required.
	Name AutomationEventFilterName

	//  The values to use for the specified filter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains information about a step in an automation event.
type AutomationEventStep struct {

	// The timestamp when this automation event step completed execution.
	CompletedTimestamp *time.Time

	//  Contains information about estimated monthly cost savings.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	//  The ID of the automation event this step belongs to.
	EventId *string

	// The unique identifier of the resource being acted upon in this step.
	ResourceId *string

	// The timestamp when this automation event step started execution.
	StartTimestamp *time.Time

	//  The unique identifier for this step.
	StepId *string

	//  The current status of the step.
	StepStatus StepStatus

	//  The type of step.
	StepType StepType

	noSmithyDocumentSerde
}

// A summary of automation events grouped by specified dimensions.
type AutomationEventSummary struct {

	// The dimensions used to group this summary, such as event status.
	Dimensions []SummaryDimension

	// The key identifier for this summary grouping.
	Key *string

	// The time period covered by this summary, with inclusive start time and
	// exclusive end time.
	TimePeriod *TimePeriod

	// The aggregated totals for this summary, including event count and estimated
	// savings.
	Total *SummaryTotals

	noSmithyDocumentSerde
}

// Represents a complete automation rule configuration including criteria,
// schedule, and execution settings.
type AutomationRule struct {

	// The 12-digit Amazon Web Services account ID that owns this automation rule.
	AccountId *string

	// The timestamp when the automation rule was created.
	CreatedTimestamp *time.Time

	// A description of the automation rule.
	Description *string

	// The timestamp when the automation rule was last updated.
	LastUpdatedTimestamp *time.Time

	// The name of the automation rule.
	Name *string

	// Configuration settings for organization-wide rules.
	OrganizationConfiguration *OrganizationConfiguration

	// A string representation of a decimal number between 0 and 1 (having up to 30
	// digits after the decimal point) that determines the priority of the rule. When
	// multiple rules match the same recommended action, Compute Optimizer assigns the
	// action to the rule with the lowest priority value (highest priority), even if
	// that rule is scheduled to run later than other matching rules.
	Priority *string

	// List of recommended action types that this rule can execute.
	RecommendedActionTypes []RecommendedActionType

	// The Amazon Resource Name (ARN) of the automation rule.
	RuleArn *string

	// The unique identifier of the automation rule.
	RuleId *string

	// The revision number of the automation rule.
	RuleRevision *int64

	// The type of automation rule (OrganizationRule or AccountRule).
	RuleType RuleType

	// The schedule configuration for when the automation rule should execute.
	Schedule *Schedule

	// The current status of the automation rule (Active or Inactive).
	Status RuleStatus

	noSmithyDocumentSerde
}

//	A set of conditions that specify which recommended action qualify for
//
// implementation. When a rule is active and a recommended action matches these
// criteria, Compute Optimizer implements the action at the scheduled run time. You
// can specify up to 20 conditions per filter criteria and 20 values per condition.
type Criteria struct {

	// Filter criteria for EBS volume sizes in gibibytes (GiB).
	EbsVolumeSizeInGib []IntegerCriteriaCondition

	// Filter criteria for EBS volume types, such as gp2, gp3, io1, io2, st1, or sc1.
	EbsVolumeType []StringCriteriaCondition

	// Filter criteria for estimated monthly cost savings from the recommended action.
	EstimatedMonthlySavings []DoubleCriteriaCondition

	// Filter criteria for the lookback period in days used to analyze resource
	// utilization.
	LookBackPeriodInDays []IntegerCriteriaCondition

	// Filter criteria for Amazon Web Services regions where resources must be located.
	Region []StringCriteriaCondition

	// Filter criteria for specific resource ARNs to include or exclude.
	ResourceArn []StringCriteriaCondition

	// Filter criteria for resource tags, allowing filtering by tag key and value
	// combinations.
	ResourceTag []ResourceTagsCriteriaCondition

	// Filter criteria indicating whether the recommended action requires a resource
	// restart.
	RestartNeeded []StringCriteriaCondition

	noSmithyDocumentSerde
}

// Defines a condition for filtering based on double/floating-point numeric values
// with comparison operators.
type DoubleCriteriaCondition struct {

	// The comparison operator to use, such as equals, greater than, less than, etc.
	Comparison ComparisonOperator

	// The list of double values to compare against using the specified comparison
	// operator.
	Values []float64

	noSmithyDocumentSerde
}

// Represents an Amazon EBS volume with its configuration and snapshot usage
// information.
type EbsVolume struct {

	// The configuration details of the EBS volume, including type, size, IOPS, and
	// throughput.
	Configuration *EbsVolumeConfiguration

	noSmithyDocumentSerde
}

// Configuration details for an Amazon EBS volume.
type EbsVolumeConfiguration struct {

	// The number of I/O operations per second (IOPS) provisioned for the volume.
	Iops *int32

	// The size of the EBS volume in gibibytes (GiB).
	SizeInGib *int32

	// The throughput in MiB/s provisioned for the volume (applicable to gp3, io1, and
	// io2bx volumes).
	Throughput *int32

	// The EBS volume type, such as gp2, gp3, io1, io2, st1, or sc1.
	Type *string

	noSmithyDocumentSerde
}

// Contains information about estimated monthly cost savings.
type EstimatedMonthlySavings struct {

	//  The estimated monthly savings after applying any discounts.
	//
	// This member is required.
	AfterDiscountSavings *float64

	//  The estimated monthly savings before applying any discounts.
	//
	// This member is required.
	BeforeDiscountSavings *float64

	//  The currency of the estimated savings.
	//
	// This member is required.
	Currency *string

	// The mode used to calculate savings, either BeforeDiscount or AfterDiscount.
	//
	// This member is required.
	SavingsEstimationMode SavingsEstimationMode

	noSmithyDocumentSerde
}

// A filter used to narrow down results based on specific criteria.
type Filter struct {

	// The name of the filter field to apply.
	//
	// This member is required.
	Name AutomationRuleFilterName

	// The list of values to filter by for the specified filter field.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Defines a condition for filtering based on integer values with comparison
// operators.
type IntegerCriteriaCondition struct {

	// The comparison operator to use, such as equals, greater than, less than, etc.
	Comparison ComparisonOperator

	// The list of integer values to compare against using the specified comparison
	// operator.
	Values []int32

	noSmithyDocumentSerde
}

// Configuration settings for organization-wide automation rules.
type OrganizationConfiguration struct {

	// List of specific Amazon Web Services account IDs where the organization rule
	// should be applied.
	AccountIds []string

	// Specifies when organization rules should be applied relative to account rules.
	RuleApplyOrder RuleApplyOrder

	noSmithyDocumentSerde
}

//	Defines the scope for organization-level rules when previewing matching
//
// actions.
type OrganizationScope struct {

	// List of Amazon Web Services account IDs to include in the organization scope.
	AccountIds []string

	noSmithyDocumentSerde
}

// Contains the results of previewing an automation rule against available
// recommendations.
type PreviewResult struct {

	// The Amazon Web Services account ID associated with the resource.
	AccountId *string

	// Detailed configuration information for a specific Amazon Web Services resource,
	// with type-specific details.
	CurrentResourceDetails ResourceDetails

	// A summary of the resource's current configuration.
	CurrentResourceSummary *string

	//  Contains information about estimated monthly cost savings.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The number of days of historical data used to analyze the resource.
	LookBackPeriodInDays *int32

	// The ID of the recommended action being previewed.
	RecommendedActionId *string

	// The type of recommended action being previewed.
	RecommendedActionType RecommendedActionType

	// Detailed configuration information for a specific Amazon Web Services resource,
	// with type-specific details.
	RecommendedResourceDetails ResourceDetails

	// A summary of the resource's recommended configuration.
	RecommendedResourceSummary *string

	// The Amazon Web Services Region where the resource is located.
	Region *string

	// The Amazon Resource Name (ARN) of the resource affected by the recommended
	// action.
	ResourceArn *string

	// The ID of the resource affected by the recommended action.
	ResourceId *string

	// The tags associated with the resource.
	ResourceTags []Tag

	// The type of resource being evaluated.
	ResourceType ResourceType

	// Indicates whether implementing the recommended action requires a resource
	// restart.
	RestartNeeded *bool

	noSmithyDocumentSerde
}

// Contains a summary of preview results for an automation rule.
type PreviewResultSummary struct {

	// The key identifier for this preview result summary.
	//
	// This member is required.
	Key *string

	// Aggregate totals for automation rule preview results, including count and
	// estimated savings.
	//
	// This member is required.
	Total *RulePreviewTotal

	noSmithyDocumentSerde
}

// Contains information about a recommended action that can be applied to optimize
// an Amazon Web Services resource.
type RecommendedAction struct {

	// The Amazon Web Services account ID that owns the resource.
	AccountId *string

	// Detailed configuration information for a specific Amazon Web Services resource,
	// with type-specific details.
	CurrentResourceDetails ResourceDetails

	// A summary of the resource's current configuration.
	CurrentResourceSummary *string

	//  Contains information about estimated monthly cost savings.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The number of days of historical data used to generate the recommendation.
	LookBackPeriodInDays *int32

	// The unique identifier of the recommended action.
	RecommendedActionId *string

	// The type of action being recommended.
	RecommendedActionType RecommendedActionType

	// Detailed configuration information for a specific Amazon Web Services resource,
	// with type-specific details.
	RecommendedResourceDetails ResourceDetails

	// A summary of the resource's recommended configuration.
	RecommendedResourceSummary *string

	// The Amazon Web Services Region where the resource is located.
	Region *string

	// The Amazon Resource Name (ARN) of the resource that the recommendation applies
	// to.
	ResourceArn *string

	// The ID of the resource that the recommendation applies to.
	ResourceId *string

	// The tags associated with the resource.
	ResourceTags []Tag

	// The type of resource being evaluated.
	ResourceType ResourceType

	// Indicates whether implementing the recommended action requires a resource
	// restart.
	RestartNeeded *bool

	noSmithyDocumentSerde
}

// A filter used to narrow down recommended action results based on specific
// criteria.
type RecommendedActionFilter struct {

	// The name of the filter field to apply.
	//
	// This member is required.
	Name RecommendedActionFilterName

	// List of filter values to match against the specified filter name. Used to
	// narrow down recommended actions based on specific criteria.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Summary information about recommended actions, grouped by specific criteria
// with totals and counts.
type RecommendedActionSummary struct {

	// The grouping key used to categorize the recommended actions in this summary.
	//
	// This member is required.
	Key *string

	// Aggregate totals for the recommended actions in this group, including count and
	// estimated savings.
	//
	// This member is required.
	Total *RecommendedActionTotal

	noSmithyDocumentSerde
}

// Aggregate totals for a group of recommended actions, including count and
// estimated monthly savings.
type RecommendedActionTotal struct {

	//  Contains information about estimated monthly cost savings.
	//
	// This member is required.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The total number of recommended actions in this group.
	//
	// This member is required.
	RecommendedActionCount *int32

	noSmithyDocumentSerde
}

// Detailed configuration information for a specific Amazon Web Services resource,
// with type-specific details.
//
// The following types satisfy this interface:
//
//	ResourceDetailsMemberEbsVolume
type ResourceDetails interface {
	isResourceDetails()
}

// Detailed configuration information specific to EBS volumes, including volume
// type, size, IOPS, and throughput settings.
type ResourceDetailsMemberEbsVolume struct {
	Value EbsVolume

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEbsVolume) isResourceDetails() {}

// Criteria condition for filtering resources based on their tags, including
// comparison operators and values.
type ResourceTagsCriteriaCondition struct {

	// The comparison operator used to evaluate the tag criteria, such as equals, not
	// equals, or contains.
	Comparison ComparisonOperator

	// The tag key to use for comparison when filtering resources.
	Key *string

	// List of tag values to compare against when filtering resources.
	Values []string

	noSmithyDocumentSerde
}

// Aggregate totals for automation rule preview results, including count and
// estimated savings.
type RulePreviewTotal struct {

	//  Contains information about estimated monthly cost savings.
	//
	// This member is required.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	// The total number of recommended actions matching the rule preview configuration.
	//
	// This member is required.
	RecommendedActionCount *int32

	noSmithyDocumentSerde
}

// Configuration for scheduling when automation rules should execute, including
// timing and execution windows.
type Schedule struct {

	// The time window in minutes during which the automation rule can start
	// implementing recommended actions.
	ExecutionWindowInMinutes *int32

	// The expression that defines when the schedule runs. cron expression is
	// supported. A cron expression consists of six fields separated by white spaces: (
	// minutes
	//     hours
	//
	//     day_of_month
	//
	//     month
	//
	//     day_of_week
	//
	// year )
	//
	// You can schedule rules to run at most once per day. Your cron expression must
	// use specific values (not wildcards) for the minutes and hours fields. For
	// example: ( 30 12 * * * ) runs daily at 12:30 PM UTC.
	ScheduleExpression *string

	// The timezone to use when interpreting the schedule expression.
	ScheduleExpressionTimezone *string

	noSmithyDocumentSerde
}

// Criteria condition for filtering based on string values, including comparison
// operators and target values.
type StringCriteriaCondition struct {

	// The comparison operator used to evaluate the string criteria, such as equals,
	// not equals, or contains.
	Comparison ComparisonOperator

	// List of string values to compare against when applying the criteria condition.
	Values []string

	noSmithyDocumentSerde
}

// A key-value pair used to categorize and group summary data for analysis and
// reporting.
type SummaryDimension struct {

	// The dimension key used for categorizing summary data.
	//
	// This member is required.
	Key SummaryDimensionKey

	// The specific value for this dimension key used in the summary grouping.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Aggregate totals for automation events, including counts and estimated savings.
type SummaryTotals struct {

	// The total number of automation events in this summary group.
	AutomationEventCount *int32

	//  Contains information about estimated monthly cost savings.
	EstimatedMonthlySavings *EstimatedMonthlySavings

	noSmithyDocumentSerde
}

// A key-value pair used to categorize and organize Amazon Web Services resources
// and automation rules.
type Tag struct {

	// The tag key, which can be up to 128 characters long.
	//
	// This member is required.
	Key *string

	// The tag value, which can be up to 256 characters long.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines a time range with inclusive start time and exclusive end time for
// filtering and analysis.
type TimePeriod struct {

	// The end time of the period, exclusive. Events before this time are included.
	EndTimeExclusive *time.Time

	// The start time of the period, inclusive. Events at or after this time are
	// included.
	StartTimeInclusive *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResourceDetails() {}
