// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates values for attributes in a data table. The value may be a default or it
// may be associated with a primary value. The value must pass all customer defined
// validation as well as the default validation for the value type. The operation
// must conform to Batch Operation API Standards. Although the standard specifies
// that successful and failed entities are listed separately in the response,
// authorization fails if any primary values or attributes are unauthorized. The
// combination of primary values and the attribute name serve as the identifier for
// the individual item request.
func (c *Client) BatchCreateDataTableValue(ctx context.Context, params *BatchCreateDataTableValueInput, optFns ...func(*Options)) (*BatchCreateDataTableValueOutput, error) {
	if params == nil {
		params = &BatchCreateDataTableValueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchCreateDataTableValue", params, optFns, c.addOperationBatchCreateDataTableValueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchCreateDataTableValueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchCreateDataTableValueInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias. If no alias is provided, the default behavior is
	// identical to providing the $LATEST alias.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// A list of values to create. Each value must specify the attribute name and
	// optionally primary values if the table has primary attributes.
	//
	// This member is required.
	Values []types.DataTableValue

	noSmithyDocumentSerde
}

type BatchCreateDataTableValueOutput struct {

	// A list of values that failed to be created with error messages explaining the
	// failure reason.
	//
	// This member is required.
	Failed []types.BatchCreateDataTableValueFailureResult

	// A list of successfully created values with their identifiers and lock versions.
	//
	// This member is required.
	Successful []types.BatchCreateDataTableValueSuccessResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchCreateDataTableValueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchCreateDataTableValue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchCreateDataTableValue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchCreateDataTableValue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchCreateDataTableValueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchCreateDataTableValue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchCreateDataTableValue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchCreateDataTableValue",
	}
}
