// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Only the VOICE, EMAIL, and TASK channels are supported.
//
//   - For VOICE: The supported initiation method is TRANSFER . The contacts
//     created with this initiation method have a subtype connect:ExternalAudio .
//
//   - For EMAIL: The supported initiation methods are OUTBOUND , AGENT_REPLY , and
//     FLOW .
//
//   - For TASK: The supported initiation method is API . Contacts created with
//     this API have a sub-type of connect:ExternalTask .
//
// Creates a new VOICE, EMAIL, or TASK contact.
//
// After a contact is created, you can move it to the desired state by using the
// InitiateAs parameter. While you can use API to create task contacts that are in
// the COMPLETED state, you must contact Amazon Web Services Support before using
// it for bulk import use cases. Bulk import causes your requests to be throttled
// or fail if your CreateContact limits aren't high enough.
func (c *Client) CreateContact(ctx context.Context, params *CreateContactInput, optFns ...func(*Options)) (*CreateContactOutput, error) {
	if params == nil {
		params = &CreateContactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateContact", params, optFns, c.addOperationCreateContactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateContactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateContactInput struct {

	// The channel for the contact.
	//
	// The CHAT channel is not supported. The following information is incorrect.
	// We're working to correct it.
	//
	// This member is required.
	Channel types.Channel

	// Indicates how the contact was initiated.
	//
	// CreateContact only supports the following initiation methods. Valid values by
	// channel are:
	//
	//   - For VOICE: TRANSFER and the subtype connect:ExternalAudio
	//
	//   - For EMAIL: OUTBOUND | AGENT_REPLY | FLOW
	//
	//   - For TASK: API
	//
	// The other channels listed below are incorrect. We're working to correct this
	// information.
	//
	// This member is required.
	InitiationMethod types.ContactInitiationMethod

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in flows just like any other
	// contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// A description of the contact.
	Description *string

	// Number of minutes the contact will be active for before expiring
	ExpiryDurationInMinutes *int32

	// Initial state of the contact when it's created. Only TASK channel contacts can
	// be initiated with COMPLETED state.
	InitiateAs types.InitiateAs

	// The name of a the contact.
	Name *string

	// The ID of the previous contact when creating a transfer contact. This value can
	// be provided only for external audio contacts. For more information, see [Integrate Amazon Connect Contact Lens with external voice systems]in the
	// Amazon Connect Administrator Guide.
	//
	// [Integrate Amazon Connect Contact Lens with external voice systems]: https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html
	PreviousContactId *string

	// A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
	// Tasks can have the following reference types at the time of creation: URL |
	// NUMBER | STRING | DATE | EMAIL | ATTACHMENT .
	References map[string]types.Reference

	// The identifier of the contact in this instance of Amazon Connect.
	RelatedContactId *string

	// A set of system defined key-value pairs stored on individual contact segments
	// (unique contact ID) using an attribute map. The attributes are standard Amazon
	// Connect attributes. They can be accessed in flows.
	//
	// Attribute keys can include only alphanumeric, -, and _.
	//
	// This field can be used to set Segment Contact Expiry as a duration in minutes.
	//
	// To set contact expiry, a ValueMap must be specified containing the integer
	// number of minutes the contact will be active for before expiring, with
	// SegmentAttributes like {  "connect:ContactExpiry": {"ValueMap" : {
	// "ExpiryDuration": { "ValueInteger": 135}}}} .
	SegmentAttributes map[string]types.SegmentAttributeValue

	// User details for the contact
	//
	// UserInfo is required when creating an EMAIL contact with OUTBOUND and
	// AGENT_REPLY contact initiation methods.
	UserInfo *types.UserInfo

	noSmithyDocumentSerde
}

type CreateContactOutput struct {

	// The Amazon Resource Name (ARN) of the created contact.
	ContactArn *string

	// The identifier of the contact in this instance of Amazon Connect.
	ContactId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateContactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateContact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateContact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateContact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateContactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateContactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateContact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateContact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateContact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateContact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateContactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateContactInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateContactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateContact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateContact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateContact",
	}
}
