// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes the alias association between two email addresses in an Amazon Connect
// instance. After disassociation, emails sent to the former alias email address
// are no longer forwarded to the primary email address. Both email addresses
// continue to exist independently and can receive emails directly.
//
// # Use cases
//
// Following are common uses cases for this API:
//
//   - Department separation: Remove alias relationships when splitting a
//     consolidated support queue back into separate department-specific queues.
//
//   - Email address retirement: Cleanly remove forwarding relationships before
//     decommissioning old email addresses.
//
//   - Organizational restructuring: Reconfigure email routing when business
//     processes change and aliases are no longer needed.
//
// Important things to know
//
//   - Concurrent operations: This API uses distributed locking, so concurrent
//     operations on the same email addresses may be temporarily blocked.
//
//   - Emails sent to the former alias address are still delivered directly to
//     that address if it exists.
//
//   - You do not need to delete the email addresses after disassociation. Both
//     addresses remain active independently.
//
//   - After a successful disassociation, you can immediately create a new alias
//     relationship with the same addresses.
//
//   - 200 status means alias was successfully disassociated.
//
// DisassociateEmailAddressAlias does not return the following information:
//
//   - Details in the response about the email that was disassociated. The
//     response returns an empty body.
//
//   - The timestamp of when the disassociation occurred.
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// # Related operations
//
// [AssociateEmailAddressAlias]
//   - : Associates an email address alias with an existing email address in an
//     Amazon Connect instance.
//
// [DescribeEmailAddress]
//   - : View current alias configurations for an email address.
//
// [SearchEmailAddresses]
//   - : Find email addresses and their alias relationships across an instance.
//
// [CreateEmailAddress]
//   - : Create new email addresses that can participate in alias relationships.
//
// [DeleteEmailAddress]
//   - : Remove email addresses (automatically removes any alias relationships).
//
// [UpdateEmailAddressMetadata]
//   - : Modify email address properties (does not affect alias relationships).
//
// [DescribeEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html
// [DeleteEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html
// [SearchEmailAddresses]: https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html
// [UpdateEmailAddressMetadata]: https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
// [CreateEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html
// [AssociateEmailAddressAlias]: https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateEmailAddressAlias.html
func (c *Client) DisassociateEmailAddressAlias(ctx context.Context, params *DisassociateEmailAddressAliasInput, optFns ...func(*Options)) (*DisassociateEmailAddressAliasOutput, error) {
	if params == nil {
		params = &DisassociateEmailAddressAliasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateEmailAddressAlias", params, optFns, c.addOperationDisassociateEmailAddressAliasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateEmailAddressAliasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateEmailAddressAliasInput struct {

	// Configuration object that specifies which alias relationship to remove. The
	// alias association must currently exist between the primary email address and the
	// specified alias email address.
	//
	// This member is required.
	AliasConfiguration *types.AliasConfiguration

	// The identifier of the email address.
	//
	// This member is required.
	EmailAddressId *string

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	noSmithyDocumentSerde
}

type DisassociateEmailAddressAliasOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateEmailAddressAliasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDisassociateEmailAddressAlias{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDisassociateEmailAddressAlias{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateEmailAddressAlias"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opDisassociateEmailAddressAliasMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateEmailAddressAliasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateEmailAddressAlias(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpDisassociateEmailAddressAlias struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpDisassociateEmailAddressAlias) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpDisassociateEmailAddressAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*DisassociateEmailAddressAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *DisassociateEmailAddressAliasInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opDisassociateEmailAddressAliasMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpDisassociateEmailAddressAlias{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opDisassociateEmailAddressAlias(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateEmailAddressAlias",
	}
}
