// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all primary value combinations for a given data table. Returns the unique
// combinations of primary attribute values that identify records in the table. Up
// to 100 records are returned per request.
func (c *Client) ListDataTablePrimaryValues(ctx context.Context, params *ListDataTablePrimaryValuesInput, optFns ...func(*Options)) (*ListDataTablePrimaryValuesOutput, error) {
	if params == nil {
		params = &ListDataTablePrimaryValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataTablePrimaryValues", params, optFns, c.addOperationListDataTablePrimaryValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataTablePrimaryValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataTablePrimaryValuesInput struct {

	// The unique identifier for the data table whose primary values should be listed.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of data table primary values to return in one page of
	// results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Optional filter to retrieve primary values matching specific criteria.
	PrimaryAttributeValues []types.PrimaryAttributeValueFilter

	// Optional list of specific record IDs to retrieve. Used for CloudFormation to
	// effectively describe records by ID. If NextToken is provided, this parameter is
	// ignored.
	RecordIds []string

	noSmithyDocumentSerde
}

type ListDataTablePrimaryValuesOutput struct {

	// A list of primary value combinations with their record IDs and modification
	// metadata.
	//
	// This member is required.
	PrimaryValuesList []types.RecordPrimaryValue

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataTablePrimaryValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataTablePrimaryValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataTablePrimaryValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataTablePrimaryValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataTablePrimaryValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataTablePrimaryValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataTablePrimaryValuesPaginatorOptions is the paginator options for
// ListDataTablePrimaryValues
type ListDataTablePrimaryValuesPaginatorOptions struct {
	// The maximum number of data table primary values to return in one page of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataTablePrimaryValuesPaginator is a paginator for
// ListDataTablePrimaryValues
type ListDataTablePrimaryValuesPaginator struct {
	options   ListDataTablePrimaryValuesPaginatorOptions
	client    ListDataTablePrimaryValuesAPIClient
	params    *ListDataTablePrimaryValuesInput
	nextToken *string
	firstPage bool
}

// NewListDataTablePrimaryValuesPaginator returns a new
// ListDataTablePrimaryValuesPaginator
func NewListDataTablePrimaryValuesPaginator(client ListDataTablePrimaryValuesAPIClient, params *ListDataTablePrimaryValuesInput, optFns ...func(*ListDataTablePrimaryValuesPaginatorOptions)) *ListDataTablePrimaryValuesPaginator {
	if params == nil {
		params = &ListDataTablePrimaryValuesInput{}
	}

	options := ListDataTablePrimaryValuesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataTablePrimaryValuesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataTablePrimaryValuesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataTablePrimaryValues page.
func (p *ListDataTablePrimaryValuesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataTablePrimaryValuesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataTablePrimaryValues(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataTablePrimaryValuesAPIClient is a client that implements the
// ListDataTablePrimaryValues operation.
type ListDataTablePrimaryValuesAPIClient interface {
	ListDataTablePrimaryValues(context.Context, *ListDataTablePrimaryValuesInput, ...func(*Options)) (*ListDataTablePrimaryValuesOutput, error)
}

var _ ListDataTablePrimaryValuesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataTablePrimaryValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataTablePrimaryValues",
	}
}
