// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the metadata properties of a data table. Accepts all fields similar to
// CreateDataTable, except for fields and tags. There are no other granular update
// endpoints. It does not act as a patch operation - all properties must be
// provided or defaults will be used. Fields follow the same requirements as
// CreateDataTable.
func (c *Client) UpdateDataTableMetadata(ctx context.Context, params *UpdateDataTableMetadataInput, optFns ...func(*Options)) (*UpdateDataTableMetadataOutput, error) {
	if params == nil {
		params = &UpdateDataTableMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDataTableMetadata", params, optFns, c.addOperationUpdateDataTableMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDataTableMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDataTableMetadataInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias. If the version is provided as part of the identifier
	// or ARN, the version must be $LATEST. Providing any other alias fails with an
	// error.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The updated name for the data table. Must conform to Connect human readable
	// string specification and have 1-127 characters. Must be unique for the instance
	// using case-insensitive comparison.
	//
	// This member is required.
	Name *string

	// The updated IANA timezone identifier to use when resolving time based dynamic
	// values.
	//
	// This member is required.
	TimeZone *string

	// The updated value lock level for the data table. One of DATA_TABLE,
	// PRIMARY_VALUE, ATTRIBUTE, VALUE, and NONE.
	//
	// This member is required.
	ValueLockLevel types.DataTableLockLevel

	// The updated description for the data table. Must conform to Connect human
	// readable string specification and have 0-250 characters.
	Description *string

	noSmithyDocumentSerde
}

type UpdateDataTableMetadataOutput struct {

	// The new lock version for the data table after the update.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDataTableMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDataTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDataTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDataTableMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDataTableMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDataTableMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDataTableMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDataTableMetadata",
	}
}
