// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a predefined attribute for the specified Amazon Connect instance. A
// predefined attribute is made up of a name and a value.
//
// For the predefined attributes per instance quota, see [Amazon Connect quotas].
//
// # Use cases
//
// Following are common uses cases for this API:
//
//   - Update routing proficiency (for example, agent certification) that has
//     predefined values (for example, a list of possible certifications). For more
//     information, see [Create predefined attributes for routing contacts to agents].
//
//   - Update an attribute for business unit name that has a list of predefined
//     business unit names used in your organization. This is a use case where
//     information for a contact varies between transfers or conferences. For more
//     information, see [Use contact segment attributes].
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// [Use contact segment attributes]: https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
// [Amazon Connect quotas]: https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas
// [Create predefined attributes for routing contacts to agents]: https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html
func (c *Client) UpdatePredefinedAttribute(ctx context.Context, params *UpdatePredefinedAttributeInput, optFns ...func(*Options)) (*UpdatePredefinedAttributeOutput, error) {
	if params == nil {
		params = &UpdatePredefinedAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePredefinedAttribute", params, optFns, c.addOperationUpdatePredefinedAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePredefinedAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePredefinedAttributeInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID in
	// the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The name of the predefined attribute.
	//
	// This member is required.
	Name *string

	// Custom metadata that is associated to predefined attributes to control behavior
	// in upstream services, such as controlling how a predefined attribute should be
	// displayed in the Amazon Connect admin website.
	AttributeConfiguration *types.InputPredefinedAttributeConfiguration

	// Values that enable you to categorize your predefined attributes. You can use
	// them in custom UI elements across the Amazon Connect admin website.
	Purposes []string

	// The values of the predefined attribute.
	Values types.PredefinedAttributeValues

	noSmithyDocumentSerde
}

type UpdatePredefinedAttributeOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePredefinedAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePredefinedAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePredefinedAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePredefinedAttribute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePredefinedAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePredefinedAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePredefinedAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePredefinedAttribute",
	}
}
