// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents the content of a particular audit event.
type AuditEvent struct {

	// Unique identifier of a case audit history event.
	//
	// This member is required.
	EventId *string

	// A list of Case Audit History event fields.
	//
	// This member is required.
	Fields []*AuditEventField

	// Time at which an Audit History event took place.
	//
	// This member is required.
	PerformedTime *time.Time

	// The Type of an audit history event.
	//
	// This member is required.
	Type AuditEventType

	// Information of the user which performed the audit.
	PerformedBy *AuditEventPerformedBy

	// The Type of the related item.
	RelatedItemType RelatedItemType

	noSmithyDocumentSerde
}

// Fields for audit event.
type AuditEventField struct {

	// Unique identifier of field in an Audit History entry.
	//
	// This member is required.
	EventFieldId *string

	// Union of potential field value types.
	//
	// This member is required.
	NewValue AuditEventFieldValueUnion

	// Union of potential field value types.
	OldValue AuditEventFieldValueUnion

	noSmithyDocumentSerde
}

// Object to store union of Field values.
//
// The following types satisfy this interface:
//
//	AuditEventFieldValueUnionMemberBooleanValue
//	AuditEventFieldValueUnionMemberDoubleValue
//	AuditEventFieldValueUnionMemberEmptyValue
//	AuditEventFieldValueUnionMemberStringValue
//	AuditEventFieldValueUnionMemberUserArnValue
type AuditEventFieldValueUnion interface {
	isAuditEventFieldValueUnion()
}

// Can be either null, or have a Boolean value type. Only one value can be
// provided.
type AuditEventFieldValueUnionMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AuditEventFieldValueUnionMemberBooleanValue) isAuditEventFieldValueUnion() {}

// Can be either null, or have a Double value type. Only one value can be provided.
type AuditEventFieldValueUnionMemberDoubleValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*AuditEventFieldValueUnionMemberDoubleValue) isAuditEventFieldValueUnion() {}

// An empty value. You cannot set EmptyFieldValue on a field that is required on a
// case template.
//
// This structure will never have any data members. It signifies an empty value on
// a case field.
type AuditEventFieldValueUnionMemberEmptyValue struct {
	Value EmptyFieldValue

	noSmithyDocumentSerde
}

func (*AuditEventFieldValueUnionMemberEmptyValue) isAuditEventFieldValueUnion() {}

// Can be either null, or have a String value type. Only one value can be provided.
type AuditEventFieldValueUnionMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AuditEventFieldValueUnionMemberStringValue) isAuditEventFieldValueUnion() {}

// Can be either null, or have a String value type formatted as an ARN. Only one
// value can be provided.
type AuditEventFieldValueUnionMemberUserArnValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*AuditEventFieldValueUnionMemberUserArnValue) isAuditEventFieldValueUnion() {}

// Information of the user which performed the audit.
type AuditEventPerformedBy struct {

	// Unique identifier of an IAM role.
	//
	// This member is required.
	IamPrincipalArn *string

	// Represents the entity that performed the action.
	User UserUnion

	noSmithyDocumentSerde
}

// Content specific to BasicLayout type. It configures fields in the top panel and
// More Info tab of agent application.
type BasicLayout struct {

	// This represents sections in a tab of the page layout.
	MoreInfo *LayoutSections

	// This represents sections in a panel of the page layout.
	TopPanel *LayoutSections

	noSmithyDocumentSerde
}

// Boolean condition for a rule. In the Amazon Connect admin website, case rules
// are known as case field conditions. For more information about case field
// conditions, see [Add case field conditions to a case template].
//
// The following types satisfy this interface:
//
//	BooleanConditionMemberEqualTo
//	BooleanConditionMemberNotEqualTo
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type BooleanCondition interface {
	isBooleanCondition()
}

// Tests that operandOne is equal to operandTwo.
type BooleanConditionMemberEqualTo struct {
	Value BooleanOperands

	noSmithyDocumentSerde
}

func (*BooleanConditionMemberEqualTo) isBooleanCondition() {}

// Tests that operandOne is not equal to operandTwo.
type BooleanConditionMemberNotEqualTo struct {
	Value BooleanOperands

	noSmithyDocumentSerde
}

func (*BooleanConditionMemberNotEqualTo) isBooleanCondition() {}

// Boolean operands for a condition. In the Amazon Connect admin website, case
// rules are known as case field conditions. For more information about case field
// conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type BooleanOperands struct {

	// Represents the left hand operand in the condition.
	//
	// This member is required.
	OperandOne OperandOne

	// Represents the right hand operand in the condition.
	//
	// This member is required.
	OperandTwo OperandTwo

	// The value of the outer rule if the condition evaluates to true.
	//
	// This member is required.
	Result *bool

	noSmithyDocumentSerde
}

// Details of what case data is published through the case event stream.
type CaseEventIncludedData struct {

	// List of field identifiers.
	//
	// This member is required.
	Fields []FieldIdentifier

	noSmithyDocumentSerde
}

// A filter for cases. Only one value can be provided.
//
// The following types satisfy this interface:
//
//	CaseFilterMemberAndAll
//	CaseFilterMemberField
//	CaseFilterMemberNot
//	CaseFilterMemberOrAll
type CaseFilter interface {
	isCaseFilter()
}

// Provides "and all" filtering.
type CaseFilterMemberAndAll struct {
	Value []CaseFilter

	noSmithyDocumentSerde
}

func (*CaseFilterMemberAndAll) isCaseFilter() {}

// A list of fields to filter on.
type CaseFilterMemberField struct {
	Value FieldFilter

	noSmithyDocumentSerde
}

func (*CaseFilterMemberField) isCaseFilter() {}

// A filter for cases. Only one value can be provided.
type CaseFilterMemberNot struct {
	Value CaseFilter

	noSmithyDocumentSerde
}

func (*CaseFilterMemberNot) isCaseFilter() {}

// Provides "or all" filtering.
type CaseFilterMemberOrAll struct {
	Value []CaseFilter

	noSmithyDocumentSerde
}

func (*CaseFilterMemberOrAll) isCaseFilter() {}

// Represents what rule type should take place, under what conditions. In the
// Amazon Connect admin website, case rules are known as case field conditions. For
// more information about case field conditions, see [Add case field conditions to a case template].
//
// The following types satisfy this interface:
//
//	CaseRuleDetailsMemberFieldOptions
//	CaseRuleDetailsMemberHidden
//	CaseRuleDetailsMemberRequired
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type CaseRuleDetails interface {
	isCaseRuleDetails()
}

// Which options are available in a child field based on the selected value in a
// parent field.
type CaseRuleDetailsMemberFieldOptions struct {
	Value FieldOptionsCaseRule

	noSmithyDocumentSerde
}

func (*CaseRuleDetailsMemberFieldOptions) isCaseRuleDetails() {}

// Whether a field is visible, based on values in other fields.
type CaseRuleDetailsMemberHidden struct {
	Value HiddenCaseRule

	noSmithyDocumentSerde
}

func (*CaseRuleDetailsMemberHidden) isCaseRuleDetails() {}

// Required rule type, used to indicate whether a field is required.
type CaseRuleDetailsMemberRequired struct {
	Value RequiredCaseRule

	noSmithyDocumentSerde
}

func (*CaseRuleDetailsMemberRequired) isCaseRuleDetails() {}

// Error for batch describe case rules API failure. In the Amazon Connect admin
// website, case rules are known as case field conditions. For more information
// about case field conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type CaseRuleError struct {

	// Error code from getting a case rule.
	//
	// This member is required.
	ErrorCode *string

	// The case rule identifier that caused the error.
	//
	// This member is required.
	Id *string

	// Error message from getting a case rule.
	Message *string

	noSmithyDocumentSerde
}

// Object containing case rule identifier information.
type CaseRuleIdentifier struct {

	// Unique identifier of a case rule.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Summary information of this case rule. In the Amazon Connect admin website,
// case rules are known as case field conditions. For more information about case
// field conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type CaseRuleSummary struct {

	// The Amazon Resource Name (ARN) of the case rule.
	//
	// This member is required.
	CaseRuleArn *string

	// Unique identifier of a case rule.
	//
	// This member is required.
	CaseRuleId *string

	// Name of the case rule.
	//
	// This member is required.
	Name *string

	// Possible types for a rule.
	//
	// This member is required.
	RuleType RuleType

	// Description of a case rule.
	Description *string

	noSmithyDocumentSerde
}

// Case summary information.
type CaseSummary struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	// A unique identifier of a template.
	//
	// This member is required.
	TemplateId *string

	noSmithyDocumentSerde
}

// Represents the content of a Comment to be returned to agents.
type CommentContent struct {

	// Text in the body of a Comment on a case.
	//
	// This member is required.
	Body *string

	// Type of the text in the box of a Comment on a case.
	//
	// This member is required.
	ContentType CommentBodyTextType

	noSmithyDocumentSerde
}

// A filter for related items of type Comment .
type CommentFilter struct {
	noSmithyDocumentSerde
}

// Represents the content of a ConnectCase type related item.
type ConnectCaseContent struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	noSmithyDocumentSerde
}

// A filter for related items of type ConnectCase .
type ConnectCaseFilter struct {

	// A unique identifier of the case.
	CaseId *string

	noSmithyDocumentSerde
}

// Represents the content of a ConnectCase related item.
type ConnectCaseInputContent struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	noSmithyDocumentSerde
}

// An object that represents an Amazon Connect contact object.
type Contact struct {

	// A unique identifier of a contact in Amazon Connect.
	//
	// This member is required.
	ContactArn *string

	noSmithyDocumentSerde
}

// An object that represents a content of an Amazon Connect contact object.
type ContactContent struct {

	// A list of channels to filter on for related items of type Contact .
	//
	// This member is required.
	Channel *string

	// The difference between the InitiationTimestamp and the DisconnectTimestamp of
	// the contact.
	//
	// This member is required.
	ConnectedToSystemTime *time.Time

	// A unique identifier of a contact in Amazon Connect.
	//
	// This member is required.
	ContactArn *string

	noSmithyDocumentSerde
}

// A filter for related items of type Contact .
type ContactFilter struct {

	// A list of channels to filter on for related items of type Contact .
	Channel []string

	// A unique identifier of a contact in Amazon Connect.
	ContactArn *string

	noSmithyDocumentSerde
}

// Represents the content of a Custom type related item.
type CustomContent struct {

	// List of field values for the Custom related item.
	//
	// This member is required.
	Fields []FieldValue

	noSmithyDocumentSerde
}

// A filter for fields in Custom type related items. Only one value can be
// provided.
//
// The following types satisfy this interface:
//
//	CustomFieldsFilterMemberAndAll
//	CustomFieldsFilterMemberField
//	CustomFieldsFilterMemberNot
//	CustomFieldsFilterMemberOrAll
type CustomFieldsFilter interface {
	isCustomFieldsFilter()
}

// Provides "and all" filtering.
type CustomFieldsFilterMemberAndAll struct {
	Value []CustomFieldsFilter

	noSmithyDocumentSerde
}

func (*CustomFieldsFilterMemberAndAll) isCustomFieldsFilter() {}

// A filter for fields. Only one value can be provided.
type CustomFieldsFilterMemberField struct {
	Value FieldFilter

	noSmithyDocumentSerde
}

func (*CustomFieldsFilterMemberField) isCustomFieldsFilter() {}

// Excludes items matching the filter.
type CustomFieldsFilterMemberNot struct {
	Value CustomFieldsFilter

	noSmithyDocumentSerde
}

func (*CustomFieldsFilterMemberNot) isCustomFieldsFilter() {}

// Provides "or all" filtering.
type CustomFieldsFilterMemberOrAll struct {
	Value []CustomFieldsFilter

	noSmithyDocumentSerde
}

func (*CustomFieldsFilterMemberOrAll) isCustomFieldsFilter() {}

// A filter for related items of type Custom .
type CustomFilter struct {

	// Filter conditions for custom fields.
	Fields CustomFieldsFilter

	noSmithyDocumentSerde
}

// Represents the content of a Custom related item.
type CustomInputContent struct {

	// List of field values for the Custom related item.
	//
	// This member is required.
	Fields []FieldValue

	noSmithyDocumentSerde
}

// Object for the summarized details of the domain.
type DomainSummary struct {

	// The Amazon Resource Name (ARN) of the domain.
	//
	// This member is required.
	DomainArn *string

	// The unique identifier of the domain.
	//
	// This member is required.
	DomainId *string

	// The name of the domain.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An empty value. You cannot set EmptyFieldValue on a field that is required on a
// case template.
//
// This structure will never have any data members. It signifies an empty value on
// a case field.
type EmptyFieldValue struct {
	noSmithyDocumentSerde
}

// Represents an empty operand value. In the Amazon Connect admin website, case
// rules are known as case field conditions. For more information about case field
// conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type EmptyOperandValue struct {
	noSmithyDocumentSerde
}

// Configuration to enable EventBridge case event delivery and determine what data
// is delivered.
type EventBridgeConfiguration struct {

	// Indicates whether the to broadcast case event data to the customer.
	//
	// This member is required.
	Enabled *bool

	// Details of what case and related item data is published through the case event
	// stream.
	IncludedData *EventIncludedData

	noSmithyDocumentSerde
}

// Details of what case and related item data is published through the case event
// stream.
type EventIncludedData struct {

	// Details of what case data is published through the case event stream.
	CaseData *CaseEventIncludedData

	// Details of what related item data is published through the case event stream.
	RelatedItemData *RelatedItemEventIncludedData

	noSmithyDocumentSerde
}

// Object for errors on fields.
type FieldError struct {

	// The error code from getting a field.
	//
	// This member is required.
	ErrorCode *string

	// The field identifier that caused the error.
	//
	// This member is required.
	Id *string

	// The error message from getting a field.
	Message *string

	noSmithyDocumentSerde
}

// A filter for fields. Only one value can be provided.
//
// The following types satisfy this interface:
//
//	FieldFilterMemberContains
//	FieldFilterMemberEqualTo
//	FieldFilterMemberGreaterThan
//	FieldFilterMemberGreaterThanOrEqualTo
//	FieldFilterMemberLessThan
//	FieldFilterMemberLessThanOrEqualTo
type FieldFilter interface {
	isFieldFilter()
}

// Object containing field identifier and value information.
type FieldFilterMemberContains struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberContains) isFieldFilter() {}

// Object containing field identifier and value information.
type FieldFilterMemberEqualTo struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberEqualTo) isFieldFilter() {}

// Object containing field identifier and value information.
type FieldFilterMemberGreaterThan struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberGreaterThan) isFieldFilter() {}

// Object containing field identifier and value information.
type FieldFilterMemberGreaterThanOrEqualTo struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberGreaterThanOrEqualTo) isFieldFilter() {}

// Object containing field identifier and value information.
type FieldFilterMemberLessThan struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberLessThan) isFieldFilter() {}

// Object containing field identifier and value information.
type FieldFilterMemberLessThanOrEqualTo struct {
	Value FieldValue

	noSmithyDocumentSerde
}

func (*FieldFilterMemberLessThanOrEqualTo) isFieldFilter() {}

// Object for a group of fields and associated properties.
type FieldGroup struct {

	// Represents an ordered list containing field related information.
	//
	// This member is required.
	Fields []FieldItem

	// Name of the field group.
	Name *string

	noSmithyDocumentSerde
}

// Object for unique identifier of a field.
type FieldIdentifier struct {

	// Unique identifier of a field.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Object for field related information.
type FieldItem struct {

	// Unique identifier of a field.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Object for field Options information.
type FieldOption struct {

	// Describes whether the FieldOption is active (displayed) or inactive.
	//
	// This member is required.
	Active *bool

	// FieldOptionName has max length 100 and disallows trailing spaces.
	//
	// This member is required.
	Name *string

	// FieldOptionValue has max length 100 and must be alphanumeric with hyphens and
	// underscores.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Object for field Options errors.
type FieldOptionError struct {

	// Error code from creating or updating field option.
	//
	// This member is required.
	ErrorCode *string

	// Error message from creating or updating field option.
	//
	// This member is required.
	Message *string

	// The field option value that caused the error.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Rules that control which options are available in a child field based on the
// selected value in a parent field.
type FieldOptionsCaseRule struct {

	// A mapping between a parent field option value and child field option values.
	//
	// This member is required.
	ParentChildFieldOptionsMappings []ParentChildFieldOptionsMapping

	// The identifier of the child field whose options are controlled.
	ChildFieldId *string

	// The identifier of the parent field that controls options.
	ParentFieldId *string

	noSmithyDocumentSerde
}

// Object for the summarized details of the field.
type FieldSummary struct {

	// The Amazon Resource Name (ARN) of the field.
	//
	// This member is required.
	FieldArn *string

	// The unique identifier of a field.
	//
	// This member is required.
	FieldId *string

	// Name of the field.
	//
	// This member is required.
	Name *string

	// The namespace of a field.
	//
	// This member is required.
	Namespace FieldNamespace

	// The type of a field.
	//
	// This member is required.
	Type FieldType

	noSmithyDocumentSerde
}

// Object for case field values.
type FieldValue struct {

	// Unique identifier of a field.
	//
	// This member is required.
	Id *string

	// Union of potential field value types.
	//
	// This member is required.
	Value FieldValueUnion

	noSmithyDocumentSerde
}

// Object to store union of Field values.
//
// The Summary system field accepts 3000 characters while all other fields accept
// 500 characters.
//
// The following types satisfy this interface:
//
//	FieldValueUnionMemberBooleanValue
//	FieldValueUnionMemberDoubleValue
//	FieldValueUnionMemberEmptyValue
//	FieldValueUnionMemberStringValue
//	FieldValueUnionMemberUserArnValue
type FieldValueUnion interface {
	isFieldValueUnion()
}

// Can be either null, or have a Boolean value type. Only one value can be
// provided.
type FieldValueUnionMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*FieldValueUnionMemberBooleanValue) isFieldValueUnion() {}

// Can be either null, or have a Double number value type. Only one value can be
// provided.
type FieldValueUnionMemberDoubleValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*FieldValueUnionMemberDoubleValue) isFieldValueUnion() {}

// An empty value.
type FieldValueUnionMemberEmptyValue struct {
	Value EmptyFieldValue

	noSmithyDocumentSerde
}

func (*FieldValueUnionMemberEmptyValue) isFieldValueUnion() {}

// String value type.
type FieldValueUnionMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*FieldValueUnionMemberStringValue) isFieldValueUnion() {}

// Represents the user that performed the audit.
type FieldValueUnionMemberUserArnValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*FieldValueUnionMemberUserArnValue) isFieldValueUnion() {}

// An object that represents a content of an Amazon Connect file object.
type FileContent struct {

	// The Amazon Resource Name (ARN) of a File in Amazon Connect.
	//
	// This member is required.
	FileArn *string

	noSmithyDocumentSerde
}

// A filter for related items of type File .
type FileFilter struct {

	// The Amazon Resource Name (ARN) of the file.
	FileArn *string

	noSmithyDocumentSerde
}

// Detailed case rule information. In the Amazon Connect admin website, case rules
// are known as case field conditions. For more information about case field
// conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type GetCaseRuleResponse struct {

	// The Amazon Resource Name (ARN) of the case rule.
	//
	// This member is required.
	CaseRuleArn *string

	// Unique identifier of a case rule.
	//
	// This member is required.
	CaseRuleId *string

	// Name of the case rule.
	//
	// This member is required.
	Name *string

	// Represents what rule type should take place, under what conditions.
	//
	// This member is required.
	Rule CaseRuleDetails

	// Timestamp when the resource was created.
	CreatedTime *time.Time

	// Indicates whether the resource has been deleted.
	Deleted bool

	// Description of a case rule.
	Description *string

	// Timestamp when the resource was created or last modified.
	LastModifiedTime *time.Time

	// A map of of key-value pairs that represent tags on a resource. Tags are used to
	// organize, track, or control access for this resource.
	Tags map[string]*string

	noSmithyDocumentSerde
}

// Object to store detailed field information.
type GetFieldResponse struct {

	// The Amazon Resource Name (ARN) of the field.
	//
	// This member is required.
	FieldArn *string

	// Unique identifier of the field.
	//
	// This member is required.
	FieldId *string

	// Name of the field.
	//
	// This member is required.
	Name *string

	// Namespace of the field.
	//
	// This member is required.
	Namespace FieldNamespace

	// Type of the field.
	//
	// This member is required.
	Type FieldType

	// Timestamp at which the resource was created.
	CreatedTime *time.Time

	// Denotes whether or not the resource has been deleted.
	Deleted bool

	// Description of the field.
	Description *string

	// Timestamp at which the resource was created or last modified.
	LastModifiedTime *time.Time

	// A map of of key-value pairs that represent tags on a resource. Tags are used to
	// organize, track, or control access for this resource.
	Tags map[string]*string

	noSmithyDocumentSerde
}

// A rule that controls field visibility based on conditions. Fields can be shown
// or hidden dynamically based on values in other fields.
type HiddenCaseRule struct {

	// A list of conditions that determine field visibility.
	//
	// This member is required.
	Conditions []BooleanCondition

	// Whether the field is hidden when no conditions match.
	//
	// This member is required.
	DefaultValue *bool

	noSmithyDocumentSerde
}

// Object to store configuration of layouts associated to the template.
type LayoutConfiguration struct {

	//  Unique identifier of a layout.
	DefaultLayout *string

	noSmithyDocumentSerde
}

// Object to store union of different versions of layout content.
//
// The following types satisfy this interface:
//
//	LayoutContentMemberBasic
type LayoutContent interface {
	isLayoutContent()
}

// Content specific to BasicLayout type. It configures fields in the top panel and
// More Info tab of Cases user interface.
type LayoutContentMemberBasic struct {
	Value BasicLayout

	noSmithyDocumentSerde
}

func (*LayoutContentMemberBasic) isLayoutContent() {}

// Ordered list containing different kinds of sections that can be added. A
// LayoutSections object can only contain one section.
type LayoutSections struct {

	// Ordered list containing different kinds of sections that can be added.
	Sections []Section

	noSmithyDocumentSerde
}

// Object for the summarized details of the layout.
type LayoutSummary struct {

	// The Amazon Resource Name (ARN) of the layout.
	//
	// This member is required.
	LayoutArn *string

	// The unique identifier for of the layout.
	//
	// This member is required.
	LayoutId *string

	// The name of the layout.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents the left hand operand in the condition. In the Amazon Connect admin
// website, case rules are known as case field conditions. For more information
// about case field conditions, see [Add case field conditions to a case template].
//
// The following types satisfy this interface:
//
//	OperandOneMemberFieldId
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type OperandOne interface {
	isOperandOne()
}

// The field ID that this operand should take the value of.
type OperandOneMemberFieldId struct {
	Value string

	noSmithyDocumentSerde
}

func (*OperandOneMemberFieldId) isOperandOne() {}

// Represents the right hand operand in the condition. In the Amazon Connect admin
// website, case rules are known as case field conditions. For more information
// about case field conditions, see [Add case field conditions to a case template].
//
// The following types satisfy this interface:
//
//	OperandTwoMemberBooleanValue
//	OperandTwoMemberDoubleValue
//	OperandTwoMemberEmptyValue
//	OperandTwoMemberStringValue
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type OperandTwo interface {
	isOperandTwo()
}

// Boolean value type.
type OperandTwoMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*OperandTwoMemberBooleanValue) isOperandTwo() {}

// Double value type.
type OperandTwoMemberDoubleValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*OperandTwoMemberDoubleValue) isOperandTwo() {}

// Empty value type.
type OperandTwoMemberEmptyValue struct {
	Value EmptyOperandValue

	noSmithyDocumentSerde
}

func (*OperandTwoMemberEmptyValue) isOperandTwo() {}

// String value type.
type OperandTwoMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*OperandTwoMemberStringValue) isOperandTwo() {}

// A mapping between a parent field option value and child field option values.
type ParentChildFieldOptionsMapping struct {

	// A list of allowed values in the child field.
	//
	// This member is required.
	ChildFieldOptionValues []string

	// The value in the parent field.
	//
	// This member is required.
	ParentFieldOptionValue *string

	noSmithyDocumentSerde
}

// Represents the content of a particular type of related item.
//
// The following types satisfy this interface:
//
//	RelatedItemContentMemberComment
//	RelatedItemContentMemberConnectCase
//	RelatedItemContentMemberContact
//	RelatedItemContentMemberCustom
//	RelatedItemContentMemberFile
//	RelatedItemContentMemberSla
type RelatedItemContent interface {
	isRelatedItemContent()
}

// Represents the content of a comment to be returned to agents.
type RelatedItemContentMemberComment struct {
	Value CommentContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberComment) isRelatedItemContent() {}

// Represents the Amazon Connect case to be created as a related item.
type RelatedItemContentMemberConnectCase struct {
	Value ConnectCaseContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberConnectCase) isRelatedItemContent() {}

// Represents the content of a contact to be returned to agents.
type RelatedItemContentMemberContact struct {
	Value ContactContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberContact) isRelatedItemContent() {}

// Represents the content of a Custom type related item.
type RelatedItemContentMemberCustom struct {
	Value CustomContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberCustom) isRelatedItemContent() {}

// Represents the content of a File to be returned to agents.
type RelatedItemContentMemberFile struct {
	Value FileContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberFile) isRelatedItemContent() {}

// Represents the content of an SLA to be returned to agents.
type RelatedItemContentMemberSla struct {
	Value SlaContent

	noSmithyDocumentSerde
}

func (*RelatedItemContentMemberSla) isRelatedItemContent() {}

// Details of what related item data is published through the case event stream.
type RelatedItemEventIncludedData struct {

	// Details of what related item data is published through the case event stream.
	//
	// This member is required.
	IncludeContent *bool

	noSmithyDocumentSerde
}

// Represents the content of a related item to be created.
//
// The following types satisfy this interface:
//
//	RelatedItemInputContentMemberComment
//	RelatedItemInputContentMemberConnectCase
//	RelatedItemInputContentMemberContact
//	RelatedItemInputContentMemberCustom
//	RelatedItemInputContentMemberFile
//	RelatedItemInputContentMemberSla
type RelatedItemInputContent interface {
	isRelatedItemInputContent()
}

// Represents the content of a comment to be returned to agents.
type RelatedItemInputContentMemberComment struct {
	Value CommentContent

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberComment) isRelatedItemInputContent() {}

// Represents the Amazon Connect case to be created as a related item.
type RelatedItemInputContentMemberConnectCase struct {
	Value ConnectCaseInputContent

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberConnectCase) isRelatedItemInputContent() {}

// Object representing a contact in Amazon Connect as an API request field.
type RelatedItemInputContentMemberContact struct {
	Value Contact

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberContact) isRelatedItemInputContent() {}

// Represents the content of a Custom type related item.
type RelatedItemInputContentMemberCustom struct {
	Value CustomInputContent

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberCustom) isRelatedItemInputContent() {}

// A file of related items.
type RelatedItemInputContentMemberFile struct {
	Value FileContent

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberFile) isRelatedItemInputContent() {}

// Represents the content of an SLA to be created.
type RelatedItemInputContentMemberSla struct {
	Value SlaInputContent

	noSmithyDocumentSerde
}

func (*RelatedItemInputContentMemberSla) isRelatedItemInputContent() {}

// The list of types of related items and their parameters to use for filtering.
//
// The following types satisfy this interface:
//
//	RelatedItemTypeFilterMemberComment
//	RelatedItemTypeFilterMemberConnectCase
//	RelatedItemTypeFilterMemberContact
//	RelatedItemTypeFilterMemberCustom
//	RelatedItemTypeFilterMemberFile
//	RelatedItemTypeFilterMemberSla
type RelatedItemTypeFilter interface {
	isRelatedItemTypeFilter()
}

// A filter for related items of type Comment .
type RelatedItemTypeFilterMemberComment struct {
	Value CommentFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberComment) isRelatedItemTypeFilter() {}

// Represents the Amazon Connect case to be created as a related item.
type RelatedItemTypeFilterMemberConnectCase struct {
	Value ConnectCaseFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberConnectCase) isRelatedItemTypeFilter() {}

// A filter for related items of type Contact .
type RelatedItemTypeFilterMemberContact struct {
	Value ContactFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberContact) isRelatedItemTypeFilter() {}

// Represents the content of a Custom type related item.
type RelatedItemTypeFilterMemberCustom struct {
	Value CustomFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberCustom) isRelatedItemTypeFilter() {}

// A filter for related items of this type of File .
type RelatedItemTypeFilterMemberFile struct {
	Value FileFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberFile) isRelatedItemTypeFilter() {}

// Filter for related items of type SLA .
type RelatedItemTypeFilterMemberSla struct {
	Value SlaFilter

	noSmithyDocumentSerde
}

func (*RelatedItemTypeFilterMemberSla) isRelatedItemTypeFilter() {}

// Required rule type, used to indicate whether a field is required. In the Amazon
// Connect admin website, case rules are known as case field conditions. For more
// information about case field conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type RequiredCaseRule struct {

	// List of conditions for the required rule; the first condition to evaluate to
	// true dictates the value of the rule.
	//
	// This member is required.
	Conditions []BooleanCondition

	// The value of the rule (that is, whether the field is required) should none of
	// the conditions evaluate to true.
	//
	// This member is required.
	DefaultValue *bool

	noSmithyDocumentSerde
}

// List of fields that must have a value provided to create a case.
type RequiredField struct {

	// Unique identifier of a field.
	//
	// This member is required.
	FieldId *string

	noSmithyDocumentSerde
}

// A list of items that represent RelatedItems. This data type is similar to [SearchRelatedItemsResponseItem]
// except SearchAllRelatedItemsResponseItem has a caseId field.
//
// [SearchRelatedItemsResponseItem]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_SearchRelatedItemsResponseItem.html
type SearchAllRelatedItemsResponseItem struct {

	// Time at which a related item was associated with a case.
	//
	// This member is required.
	AssociationTime *time.Time

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	// Represents the content of a particular type of related item.
	//
	// This member is required.
	Content RelatedItemContent

	// Unique identifier of a related item.
	//
	// This member is required.
	RelatedItemId *string

	// Type of a related item.
	//
	// This member is required.
	Type RelatedItemType

	// Represents the entity that performed the action.
	PerformedBy UserUnion

	// A map of of key-value pairs that represent tags on a resource. Tags are used to
	// organize, track, or control access for this resource.
	Tags map[string]*string

	noSmithyDocumentSerde
}

// The order in which all returned related items should be sorted.
type SearchAllRelatedItemsSort struct {

	// Whether related items should be sorted by association time or case ID.
	//
	// This member is required.
	SortOrder Order

	// Whether related items should be sorted in ascending or descending order.
	//
	// This member is required.
	SortProperty SearchAllRelatedItemsSortProperty

	noSmithyDocumentSerde
}

// A list of items that represent cases.
type SearchCasesResponseItem struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	// List of case field values.
	//
	// This member is required.
	Fields []FieldValue

	// A unique identifier of a template.
	//
	// This member is required.
	TemplateId *string

	// A map of of key-value pairs that represent tags on a resource. Tags are used to
	// organize, track, or control access for this resource.
	Tags map[string]*string

	noSmithyDocumentSerde
}

// A list of items that represent RelatedItems.
type SearchRelatedItemsResponseItem struct {

	// Time at which a related item was associated with a case.
	//
	// This member is required.
	AssociationTime *time.Time

	// Represents the content of a particular type of related item.
	//
	// This member is required.
	Content RelatedItemContent

	// Unique identifier of a related item.
	//
	// This member is required.
	RelatedItemId *string

	// Type of a related item.
	//
	// This member is required.
	Type RelatedItemType

	// Represents the creator of the related item.
	PerformedBy UserUnion

	// A map of of key-value pairs that represent tags on a resource. Tags are used to
	// organize, track, or control access for this resource.
	Tags map[string]*string

	noSmithyDocumentSerde
}

// This represents a sections within a panel or tab of the page layout.
//
// The following types satisfy this interface:
//
//	SectionMemberFieldGroup
type Section interface {
	isSection()
}

// Consists of a group of fields and associated properties.
type SectionMemberFieldGroup struct {
	Value FieldGroup

	noSmithyDocumentSerde
}

func (*SectionMemberFieldGroup) isSection() {}

// Represents an SLA configuration.
type SlaConfiguration struct {

	// Name of an SLA.
	//
	// This member is required.
	Name *string

	// Status of an SLA.
	//
	// This member is required.
	Status SlaStatus

	// Target time by which an SLA should be completed.
	//
	// This member is required.
	TargetTime *time.Time

	// Type of SLA.
	//
	// This member is required.
	Type SlaType

	// Time at which an SLA was completed.
	CompletionTime *time.Time

	// Unique identifier of a field.
	FieldId *string

	// Represents a list of target field values for the fieldId specified in
	// SlaConfiguration.
	TargetFieldValues []FieldValueUnion

	noSmithyDocumentSerde
}

// Represents the content of an SLA to be returned to agents.
type SlaContent struct {

	// Represents an SLA configuration.
	//
	// This member is required.
	SlaConfiguration *SlaConfiguration

	noSmithyDocumentSerde
}

// A filter for related items of type SLA .
type SlaFilter struct {

	// Name of an SLA.
	Name *string

	// Status of an SLA.
	Status SlaStatus

	noSmithyDocumentSerde
}

// Represents the input configuration of an SLA being created.
type SlaInputConfiguration struct {

	// Name of an SLA.
	//
	// This member is required.
	Name *string

	// Target duration in minutes within which an SLA should be completed.
	//
	// This member is required.
	TargetSlaMinutes *int64

	// Type of SLA.
	//
	// This member is required.
	Type SlaType

	// Unique identifier of a field.
	FieldId *string

	// Represents a list of target field values for the fieldId specified in
	// SlaInputConfiguration. The SLA is considered met if any one of these target
	// field values matches the actual field value.
	TargetFieldValues []FieldValueUnion

	noSmithyDocumentSerde
}

// Represents the content of an SLA.
//
// The following types satisfy this interface:
//
//	SlaInputContentMemberSlaInputConfiguration
type SlaInputContent interface {
	isSlaInputContent()
}

// Represents an input SLA configuration.
type SlaInputContentMemberSlaInputConfiguration struct {
	Value SlaInputConfiguration

	noSmithyDocumentSerde
}

func (*SlaInputContentMemberSlaInputConfiguration) isSlaInputContent() {}

// A structured set of sort terms.
type Sort struct {

	// Unique identifier of a field.
	//
	// This member is required.
	FieldId *string

	// A structured set of sort terms
	//
	// This member is required.
	SortOrder Order

	noSmithyDocumentSerde
}

// An association representing a case rule acting upon a field. In the Amazon
// Connect admin website, case rules are known as case field conditions. For more
// information about case field conditions, see [Add case field conditions to a case template].
//
// [Add case field conditions to a case template]: https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html
type TemplateRule struct {

	// Unique identifier of a case rule.
	//
	// This member is required.
	CaseRuleId *string

	// Unique identifier of a field.
	FieldId *string

	noSmithyDocumentSerde
}

// Template summary information.
type TemplateSummary struct {

	// The template name.
	//
	// This member is required.
	Name *string

	// The status of the template.
	//
	// This member is required.
	Status TemplateStatus

	// The Amazon Resource Name (ARN) of the template.
	//
	// This member is required.
	TemplateArn *string

	// The unique identifier for the template.
	//
	// This member is required.
	TemplateId *string

	noSmithyDocumentSerde
}

// Represents the entity that performed the action.
//
// The following types satisfy this interface:
//
//	UserUnionMemberCustomEntity
//	UserUnionMemberUserArn
type UserUnion interface {
	isUserUnion()
}

// Any provided entity.
type UserUnionMemberCustomEntity struct {
	Value string

	noSmithyDocumentSerde
}

func (*UserUnionMemberCustomEntity) isUserUnion() {}

// Represents the Amazon Connect ARN of the user.
type UserUnionMemberUserArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*UserUnionMemberUserArn) isUserUnion() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAuditEventFieldValueUnion() {}
func (*UnknownUnionMember) isBooleanCondition()          {}
func (*UnknownUnionMember) isCaseFilter()                {}
func (*UnknownUnionMember) isCaseRuleDetails()           {}
func (*UnknownUnionMember) isCustomFieldsFilter()        {}
func (*UnknownUnionMember) isFieldFilter()               {}
func (*UnknownUnionMember) isFieldValueUnion()           {}
func (*UnknownUnionMember) isLayoutContent()             {}
func (*UnknownUnionMember) isOperandOne()                {}
func (*UnknownUnionMember) isOperandTwo()                {}
func (*UnknownUnionMember) isRelatedItemContent()        {}
func (*UnknownUnionMember) isRelatedItemInputContent()   {}
func (*UnknownUnionMember) isRelatedItemTypeFilter()     {}
func (*UnknownUnionMember) isSection()                   {}
func (*UnknownUnionMember) isSlaInputContent()           {}
func (*UnknownUnionMember) isUserUnion()                 {}
