// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A summary of the domain that a common control or an objective belongs to.
type AssociatedDomainSummary struct {

	// The Amazon Resource Name (ARN) of the related domain.
	Arn *string

	// The name of the related domain.
	Name *string

	noSmithyDocumentSerde
}

// A summary of the objective that a common control supports.
type AssociatedObjectiveSummary struct {

	// The Amazon Resource Name (ARN) of the related objective.
	Arn *string

	// The name of the related objective.
	Name *string

	noSmithyDocumentSerde
}

// An optional filter that narrows the results to a specific objective.
type CommonControlFilter struct {

	// The objective that's used as filter criteria.
	//
	// You can use this parameter to specify one objective ARN at a time. Passing
	// multiple ARNs in the CommonControlFilter isn’t supported.
	Objectives []ObjectiveResourceFilter

	noSmithyDocumentSerde
}

// A structure that contains details about a common control mapping. In
// particular, it returns the Amazon Resource Name (ARN) of the common control.
type CommonControlMappingDetails struct {

	// The Amazon Resource Name (ARN) that identifies the common control in the
	// mapping.
	//
	// This member is required.
	CommonControlArn *string

	noSmithyDocumentSerde
}

// A summary of metadata for a common control.
type CommonControlSummary struct {

	// The Amazon Resource Name (ARN) that identifies the common control.
	//
	// This member is required.
	Arn *string

	// The time when the common control was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The description of the common control.
	//
	// This member is required.
	Description *string

	// The domain that the common control belongs to.
	//
	// This member is required.
	Domain *AssociatedDomainSummary

	// The time when the common control was most recently updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The name of the common control.
	//
	// This member is required.
	Name *string

	// The objective that the common control belongs to.
	//
	// This member is required.
	Objective *AssociatedObjectiveSummary

	noSmithyDocumentSerde
}

// A structure that defines filtering criteria for the ListControls operation. You
// can use this filter to narrow down the list of controls based on their
// implementation details.
type ControlFilter struct {

	// A filter that narrows the results to controls with specific implementation
	// types or identifiers. This field allows you to find controls that are
	// implemented by specific Amazon Web Services services or with specific service
	// identifiers.
	Implementations *ImplementationFilter

	noSmithyDocumentSerde
}

// A structure that contains information about a control mapping, including the
// control ARN, mapping type, and mapping details.
type ControlMapping struct {

	// The Amazon Resource Name (ARN) that identifies the control in the mapping.
	//
	// This member is required.
	ControlArn *string

	// The details of the mapping relationship, for example, containing framework,
	// common control, or related control information.
	//
	// This member is required.
	Mapping Mapping

	// The type of mapping relationship between the control and other entities.
	//
	// This member is required.
	MappingType MappingType

	noSmithyDocumentSerde
}

// A structure that defines filtering criteria for the ListControlMappings
// operation. You can use this filter to narrow down the list of control mappings
// based on control ARNs, common control ARNs, or mapping types.
type ControlMappingFilter struct {

	// A list of common control ARNs to filter the mappings. When specified, only
	// mappings associated with these common controls are returned.
	CommonControlArns []string

	// A list of control ARNs to filter the mappings. When specified, only mappings
	// associated with these controls are returned.
	ControlArns []string

	// A list of mapping types to filter the mappings. When specified, only mappings
	// of these types are returned.
	MappingTypes []MappingType

	noSmithyDocumentSerde
}

// Five types of control parameters are supported.
//
//   - AllowedRegions: List of Amazon Web Services Regions exempted from the
//     control. Each string is expected to be an Amazon Web Services Region code. This
//     parameter is mandatory for the OU Region deny control, CT.MULTISERVICE.PV.1.
//
// Example: ["us-east-1","us-west-2"]
//
//   - ExemptedActions: List of Amazon Web Services IAM actions exempted from the
//     control. Each string is expected to be an IAM action.
//
// Example: ["logs:DescribeLogGroups","logs:StartQuery","logs:GetQueryResults"]
//
//   - ExemptedPrincipalArns: List of Amazon Web Services IAM principal ARNs
//     exempted from the control. Each string is expected to be an IAM principal that
//     follows the pattern ^arn:(aws|aws-us-gov):(iam|sts)::.+:.+$
//
// Example:
//
//	["arn:aws:iam::*:role/ReadOnly","arn:aws:sts::*:assumed-role/ReadOnly/*"]
//
//	- ExemptedResourceArns: List of resource ARNs exempted from the control. Each
//	string is expected to be a resource ARN.
//
// Example: ["arn:aws:s3:::my-bucket-name"]
//
//   - ExemptAssumeRoot: A parameter that lets you choose whether to exempt
//     requests made with AssumeRoot from this control, for this OU. For member
//     accounts, the AssumeRoot property is included in requests initiated by IAM
//     centralized root access. This parameter applies only to the
//     AWS-GR_RESTRICT_ROOT_USER control. If you add the parameter when enabling the
//     control, the AssumeRoot exemption is allowed. If you omit the parameter, the
//     AssumeRoot exception is not permitted. The parameter does not accept False as
//     a value.
//
// Example: Enabling the control and allowing AssumeRoot
//
// { "controlIdentifier":
//
//	"arn:aws:controlcatalog:::control/5kvme4m5d2b4d7if2fs5yg2ui", "parameters": [ {
//	"key": "ExemptAssumeRoot", "value": true } ], "targetIdentifier":
//	"arn:aws:organizations::8633900XXXXX:ou/o-6jmn81636m/ou-qsah-jtiihcla" }
type ControlParameter struct {

	// The parameter name. This name is the parameter key when you call [EnableControl]EnableControl
	// or [UpdateEnabledControl]UpdateEnabledControl .
	//
	// [EnableControl]: https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
	// [UpdateEnabledControl]: https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Overview of information about a control.
type ControlSummary struct {

	// The Amazon Resource Name (ARN) of the control.
	//
	// This member is required.
	Arn *string

	// A description of the control, as it may appear in the console. Describes the
	// functionality of the control.
	//
	// This member is required.
	Description *string

	// The display name of the control.
	//
	// This member is required.
	Name *string

	// A list of alternative identifiers for the control. These are human-readable
	// designators, such as SH.S3.1 . Several aliases can refer to the same control
	// across different Amazon Web Services services or compliance frameworks.
	Aliases []string

	// An enumerated type, with the following possible values:
	Behavior ControlBehavior

	// A timestamp that notes the time when the control was released (start of its
	// life) as a governance capability in Amazon Web Services.
	CreateTime *time.Time

	// A list of Amazon Web Services resource types that are governed by this control.
	// This information helps you understand which controls can govern certain types of
	// resources, and conversely, which resources are affected when the control is
	// implemented. The resources are represented as Amazon Web Services CloudFormation
	// resource types. If GovernedResources cannot be represented by available
	// CloudFormation resource types, it’s returned as an empty list.
	GovernedResources []string

	// An object of type ImplementationSummary that describes how the control is
	// implemented.
	Implementation *ImplementationSummary

	// An enumerated type, with the following possible values:
	Severity ControlSeverity

	noSmithyDocumentSerde
}

// The domain resource that's being used as a filter.
type DomainResourceFilter struct {

	// The Amazon Resource Name (ARN) of the domain.
	Arn *string

	noSmithyDocumentSerde
}

// A summary of metadata for a domain.
type DomainSummary struct {

	// The Amazon Resource Name (ARN) that identifies the domain.
	//
	// This member is required.
	Arn *string

	// The time when the domain was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The description of the domain.
	//
	// This member is required.
	Description *string

	// The time when the domain was most recently updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The name of the domain.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A structure that contains details about a framework mapping, including the
// framework name and specific item within the framework that the control maps to.
type FrameworkMappingDetails struct {

	// The specific item or requirement within the framework that the control maps to.
	//
	// This member is required.
	Item *string

	// The name of the compliance framework that the control maps to.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An object that describes the implementation type for a control.
//
// Our ImplementationDetails Type format has three required segments:
//
//   - SERVICE-PROVIDER::SERVICE-NAME::RESOURCE-NAME
//
// For example, AWS::Config::ConfigRule or AWS::SecurityHub::SecurityControl
// resources have the format with three required segments.
//
// Our ImplementationDetails Type format has an optional fourth segment, which is
// present for applicable implementation types. The format is as follows:
//
//   - SERVICE-PROVIDER::SERVICE-NAME::RESOURCE-NAME::RESOURCE-TYPE-DESCRIPTION
//
// For example, AWS::Organizations::Policy::SERVICE_CONTROL_POLICY or
// AWS::CloudFormation::Type::HOOK have the format with four segments.
//
// Although the format is similar, the values for the Type field do not match any
// Amazon Web Services CloudFormation values.
type ImplementationDetails struct {

	// A string that describes a control's implementation type.
	//
	// This member is required.
	Type *string

	// A service-specific identifier for the control, assigned by the service that
	// implemented the control. For example, this identifier could be an Amazon Web
	// Services Config Rule ID or a Security Hub Control ID.
	Identifier *string

	noSmithyDocumentSerde
}

// A structure that defines filtering criteria for control implementations. You
// can use this filter to find controls that are implemented by specific Amazon Web
// Services services or with specific service identifiers.
type ImplementationFilter struct {

	// A list of service-specific identifiers that can serve as filters. For example,
	// you can filter for controls with specific Amazon Web Services Config Rule IDs or
	// Security Hub Control IDs.
	Identifiers []string

	// A list of implementation types that can serve as filters. For example, you can
	// filter for controls implemented as Amazon Web Services Config Rules by
	// specifying AWS::Config::ConfigRule as a type.
	Types []string

	noSmithyDocumentSerde
}

// A summary of how the control is implemented, including the Amazon Web Services
// service that enforces the control and its service-specific identifier. For
// example, the value of this field could indicate that the control is implemented
// as an Amazon Web Services Config Rule or an Amazon Web Services Security Hub
// control.
type ImplementationSummary struct {

	// A string that represents the Amazon Web Services service that implements this
	// control. For example, a value of AWS::Config::ConfigRule indicates that the
	// control is implemented by Amazon Web Services Config, and
	// AWS::SecurityHub::SecurityControl indicates implementation by Amazon Web
	// Services Security Hub.
	//
	// This member is required.
	Type *string

	// The identifier originally assigned by the Amazon Web Services service that
	// implements the control. For example, CODEPIPELINE_DEPLOYMENT_COUNT_CHECK .
	Identifier *string

	noSmithyDocumentSerde
}

// A structure that contains the details of a mapping relationship, which can be
// either to a framework or to a common control.
//
// The following types satisfy this interface:
//
//	MappingMemberCommonControl
//	MappingMemberFramework
//	MappingMemberRelatedControl
type Mapping interface {
	isMapping()
}

// The common control mapping details when the mapping type relates to a common
// control.
type MappingMemberCommonControl struct {
	Value CommonControlMappingDetails

	noSmithyDocumentSerde
}

func (*MappingMemberCommonControl) isMapping() {}

// The framework mapping details when the mapping type relates to a compliance
// framework.
type MappingMemberFramework struct {
	Value FrameworkMappingDetails

	noSmithyDocumentSerde
}

func (*MappingMemberFramework) isMapping() {}

// Returns information about controls that are related to the specified control.
type MappingMemberRelatedControl struct {
	Value RelatedControlMappingDetails

	noSmithyDocumentSerde
}

func (*MappingMemberRelatedControl) isMapping() {}

// An optional filter that narrows the list of objectives to a specific domain.
type ObjectiveFilter struct {

	// The domain that's used as filter criteria.
	//
	// You can use this parameter to specify one domain ARN at a time. Passing
	// multiple ARNs in the ObjectiveFilter isn’t supported.
	Domains []DomainResourceFilter

	noSmithyDocumentSerde
}

// The objective resource that's being used as a filter.
type ObjectiveResourceFilter struct {

	// The Amazon Resource Name (ARN) of the objective.
	Arn *string

	noSmithyDocumentSerde
}

// A summary of metadata for an objective.
type ObjectiveSummary struct {

	// The Amazon Resource Name (ARN) that identifies the objective.
	//
	// This member is required.
	Arn *string

	// The time when the objective was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The description of the objective.
	//
	// This member is required.
	Description *string

	// The domain that the objective belongs to.
	//
	// This member is required.
	Domain *AssociatedDomainSummary

	// The time when the objective was most recently updated.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The name of the objective.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Returns information about the control, including the scope of the control, if
// enabled, and the Regions in which the control is available for deployment. For
// more information about scope, see [Global services].
//
// If you are applying controls through an Amazon Web Services Control Tower
// landing zone environment, remember that the values returned in the
// RegionConfiguration API operation are not related to the governed Regions in
// your landing zone. For example, if you are governing Regions A , B ,and C while
// the control is available in Regions A , B , C , and D , you'd see a response
// with DeployableRegions of A , B , C , and D for a control with REGIONAL scope,
// even though you may not intend to deploy the control in Region D , because you
// do not govern it through your landing zone.
//
// [Global services]: https://docs.aws.amazon.com/whitepapers/latest/aws-fault-isolation-boundaries/global-services.html
type RegionConfiguration struct {

	// The coverage of the control, if deployed. Scope is an enumerated type, with
	// value Regional , or Global . A control with Global scope is effective in all
	// Amazon Web Services Regions, regardless of the Region from which it is enabled,
	// or to which it is deployed. A control implemented by an SCP is usually Global in
	// scope. A control with Regional scope has operations that are restricted
	// specifically to the Region from which it is enabled and to which it is deployed.
	// Controls implemented by Config rules and CloudFormation hooks usually are
	// Regional in scope. Security Hub controls usually are Regional in scope.
	//
	// This member is required.
	Scope ControlScope

	// Regions in which the control is available to be deployed.
	DeployableRegions []string

	noSmithyDocumentSerde
}

// A structure that describes a control's relationship status with other controls.
type RelatedControlMappingDetails struct {

	// Returns an enumerated value that represents the relationship between two or
	// more controls.
	//
	// This member is required.
	RelationType ControlRelationType

	// The unique identifier of a control.
	ControlArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isMapping() {}
