// Code generated by smithy-go-codegen DO NOT EDIT.

package costoptimizationhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costoptimizationhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns cost efficiency metrics aggregated over time and optionally grouped by
// a specified dimension. The metrics provide insights into your cost optimization
// progress by tracking estimated savings, spending, and measures how effectively
// you're optimizing your Cloud resources.
//
// The operation supports both daily and monthly time granularities and allows
// grouping results by account ID, Amazon Web Services Region. Results are returned
// as time-series data, enabling you to analyze trends in your cost optimization
// performance over the specified time period.
func (c *Client) ListEfficiencyMetrics(ctx context.Context, params *ListEfficiencyMetricsInput, optFns ...func(*Options)) (*ListEfficiencyMetricsOutput, error) {
	if params == nil {
		params = &ListEfficiencyMetricsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEfficiencyMetrics", params, optFns, c.addOperationListEfficiencyMetricsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEfficiencyMetricsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEfficiencyMetricsInput struct {

	// The time granularity for the cost efficiency metrics. Specify Daily for metrics
	// aggregated by day, or Monthly for metrics aggregated by month.
	//
	// This member is required.
	Granularity types.GranularityType

	// The time period for which to retrieve the cost efficiency metrics. The start
	// date is inclusive and the end date is exclusive. Dates can be specified in
	// either YYYY-MM-DD format or YYYY-MM format depending on the desired granularity.
	//
	// This member is required.
	TimePeriod *types.TimePeriod

	// The dimension by which to group the cost efficiency metrics. Valid values
	// include account ID, Amazon Web Services Region. When no grouping is specified,
	// metrics are aggregated across all resources in the specified time period.
	GroupBy *string

	// The maximum number of groups to return in the response. Valid values range from
	// 0 to 1000. Use in conjunction with nextToken to paginate through results when
	// the total number of groups exceeds this limit.
	MaxResults *int32

	// The token to retrieve the next page of results. This value is returned in the
	// response when the number of groups exceeds the specified maxResults value.
	NextToken *string

	// The ordering specification for the results. Defines which dimension to sort by
	// and whether to sort in ascending or descending order.
	OrderBy *types.OrderBy

	noSmithyDocumentSerde
}

type ListEfficiencyMetricsOutput struct {

	// A list of cost efficiency metrics grouped by the specified dimension. Each
	// group contains time-series data points with cost efficiency, potential savings,
	// and optimzable spend for the specified time period.
	EfficiencyMetricsByGroup []types.EfficiencyMetricsByGroup

	// The token to retrieve the next page of results. When this value is present in
	// the response, additional groups are available. Pass this token in the nextToken
	// parameter of a subsequent request to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEfficiencyMetricsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEfficiencyMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEfficiencyMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEfficiencyMetrics"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEfficiencyMetricsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEfficiencyMetrics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEfficiencyMetricsPaginatorOptions is the paginator options for
// ListEfficiencyMetrics
type ListEfficiencyMetricsPaginatorOptions struct {
	// The maximum number of groups to return in the response. Valid values range from
	// 0 to 1000. Use in conjunction with nextToken to paginate through results when
	// the total number of groups exceeds this limit.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEfficiencyMetricsPaginator is a paginator for ListEfficiencyMetrics
type ListEfficiencyMetricsPaginator struct {
	options   ListEfficiencyMetricsPaginatorOptions
	client    ListEfficiencyMetricsAPIClient
	params    *ListEfficiencyMetricsInput
	nextToken *string
	firstPage bool
}

// NewListEfficiencyMetricsPaginator returns a new ListEfficiencyMetricsPaginator
func NewListEfficiencyMetricsPaginator(client ListEfficiencyMetricsAPIClient, params *ListEfficiencyMetricsInput, optFns ...func(*ListEfficiencyMetricsPaginatorOptions)) *ListEfficiencyMetricsPaginator {
	if params == nil {
		params = &ListEfficiencyMetricsInput{}
	}

	options := ListEfficiencyMetricsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEfficiencyMetricsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEfficiencyMetricsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEfficiencyMetrics page.
func (p *ListEfficiencyMetricsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEfficiencyMetricsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEfficiencyMetrics(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEfficiencyMetricsAPIClient is a client that implements the
// ListEfficiencyMetrics operation.
type ListEfficiencyMetricsAPIClient interface {
	ListEfficiencyMetrics(context.Context, *ListEfficiencyMetricsInput, ...func(*Options)) (*ListEfficiencyMetricsOutput, error)
}

var _ ListEfficiencyMetricsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEfficiencyMetrics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEfficiencyMetrics",
	}
}
