// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// The GetObjectTypeAttributeValues API delivers statistical insights about
// attributes within a specific object type, but is exclusively available for
// domains with data store enabled. This API performs daily calculations to provide
// statistical information about your attribute values, helping you understand
// patterns and trends in your data. The statistical calculations are performed
// once per day, providing a consistent snapshot of your attribute data
// characteristics.
//
// You'll receive null values in two scenarios:
//
// During the first period after enabling data vault (unless a calculation cycle
// occurs, which happens once daily).
//
// For attributes that don't contain numeric values.
func (c *Client) GetObjectTypeAttributeStatistics(ctx context.Context, params *GetObjectTypeAttributeStatisticsInput, optFns ...func(*Options)) (*GetObjectTypeAttributeStatisticsOutput, error) {
	if params == nil {
		params = &GetObjectTypeAttributeStatisticsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetObjectTypeAttributeStatistics", params, optFns, c.addOperationGetObjectTypeAttributeStatisticsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetObjectTypeAttributeStatisticsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetObjectTypeAttributeStatisticsInput struct {

	// The attribute name.
	//
	// This member is required.
	AttributeName *string

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique name of the domain object type.
	//
	// This member is required.
	ObjectTypeName *string

	noSmithyDocumentSerde
}

type GetObjectTypeAttributeStatisticsOutput struct {

	// Time when this statistics was calculated.
	//
	// This member is required.
	CalculatedAt *time.Time

	// The statistics.
	//
	// This member is required.
	Statistics *types.GetObjectTypeAttributeStatisticsStats

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetObjectTypeAttributeStatisticsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetObjectTypeAttributeStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetObjectTypeAttributeStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetObjectTypeAttributeStatistics"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetObjectTypeAttributeStatisticsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetObjectTypeAttributeStatistics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetObjectTypeAttributeStatistics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetObjectTypeAttributeStatistics",
	}
}
