// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a history record for a specific profile, for a specific domain.
func (c *Client) GetProfileHistoryRecord(ctx context.Context, params *GetProfileHistoryRecordInput, optFns ...func(*Options)) (*GetProfileHistoryRecordOutput, error) {
	if params == nil {
		params = &GetProfileHistoryRecordInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetProfileHistoryRecord", params, optFns, c.addOperationGetProfileHistoryRecordMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetProfileHistoryRecordOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetProfileHistoryRecordInput struct {

	// The unique name of the domain for which to return a profile history record.
	//
	// This member is required.
	DomainName *string

	// The unique identifier of the profile history record to return.
	//
	// This member is required.
	Id *string

	// The unique identifier of the profile for which to return a history record.
	//
	// This member is required.
	ProfileId *string

	noSmithyDocumentSerde
}

type GetProfileHistoryRecordOutput struct {

	// The action type of the profile history record.
	//
	// This member is required.
	ActionType types.ActionType

	// The timestamp of when the profile history record was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the profile history record.
	//
	// This member is required.
	Id *string

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// A string containing the customer profile, profile object, or profile key
	// content.
	Content *string

	// The timestamp of when the profile history record was last updated.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the person or service principal who performed
	// the action.
	PerformedBy *string

	// The unique identifier of the profile object generated by the service.
	ProfileObjectUniqueKey *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetProfileHistoryRecordMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetProfileHistoryRecord{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetProfileHistoryRecord{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetProfileHistoryRecord"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetProfileHistoryRecordValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetProfileHistoryRecord(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetProfileHistoryRecord(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetProfileHistoryRecord",
	}
}
