// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The ListObjectTypeAttributeValues API provides access to the most recent
// distinct values for any specified attribute, making it valuable for real-time
// data validation and consistency checks within your object types. This API works
// across domain, supporting both custom and standard object types. The API accepts
// the object type name, attribute name, and domain name as input parameters and
// returns values up to the storage limit of approximately 350KB.
func (c *Client) ListObjectTypeAttributeValues(ctx context.Context, params *ListObjectTypeAttributeValuesInput, optFns ...func(*Options)) (*ListObjectTypeAttributeValuesOutput, error) {
	if params == nil {
		params = &ListObjectTypeAttributeValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListObjectTypeAttributeValues", params, optFns, c.addOperationListObjectTypeAttributeValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListObjectTypeAttributeValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListObjectTypeAttributeValuesInput struct {

	// The attribute name.
	//
	// This member is required.
	AttributeName *string

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique name of the domain object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The maximum number of objects returned per page. Valid Range: Minimum value of
	// 1. Maximum value of 100. If not provided default as 100.
	MaxResults *int32

	// The pagination token from the previous call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListObjectTypeAttributeValuesOutput struct {

	// A list of unique attribute values sorted on the basis of LastUpdatedAt.
	Items []types.ListObjectTypeAttributeValuesItem

	// The pagination token from the previous call to call
	// ListObjectTypeAttributeValues.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListObjectTypeAttributeValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListObjectTypeAttributeValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListObjectTypeAttributeValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListObjectTypeAttributeValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListObjectTypeAttributeValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListObjectTypeAttributeValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListObjectTypeAttributeValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListObjectTypeAttributeValues",
	}
}
