// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of available recommender recipes that can be used to create
// recommenders.
func (c *Client) ListRecommenderRecipes(ctx context.Context, params *ListRecommenderRecipesInput, optFns ...func(*Options)) (*ListRecommenderRecipesOutput, error) {
	if params == nil {
		params = &ListRecommenderRecipesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRecommenderRecipes", params, optFns, c.addOperationListRecommenderRecipesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRecommenderRecipesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRecommenderRecipesInput struct {

	// The maximum number of recommender recipes to return in the response. The
	// default value is 100.
	MaxResults *int32

	// A token received from a previous ListRecommenderRecipes call to retrieve the
	// next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRecommenderRecipesOutput struct {

	// A token to retrieve the next page of results. Null if there are no more results
	// to retrieve.
	NextToken *string

	// A list of available recommender recipes and their properties.
	RecommenderRecipes []types.RecommenderRecipe

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRecommenderRecipesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRecommenderRecipes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRecommenderRecipes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRecommenderRecipes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRecommenderRecipes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRecommenderRecipesPaginatorOptions is the paginator options for
// ListRecommenderRecipes
type ListRecommenderRecipesPaginatorOptions struct {
	// The maximum number of recommender recipes to return in the response. The
	// default value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRecommenderRecipesPaginator is a paginator for ListRecommenderRecipes
type ListRecommenderRecipesPaginator struct {
	options   ListRecommenderRecipesPaginatorOptions
	client    ListRecommenderRecipesAPIClient
	params    *ListRecommenderRecipesInput
	nextToken *string
	firstPage bool
}

// NewListRecommenderRecipesPaginator returns a new ListRecommenderRecipesPaginator
func NewListRecommenderRecipesPaginator(client ListRecommenderRecipesAPIClient, params *ListRecommenderRecipesInput, optFns ...func(*ListRecommenderRecipesPaginatorOptions)) *ListRecommenderRecipesPaginator {
	if params == nil {
		params = &ListRecommenderRecipesInput{}
	}

	options := ListRecommenderRecipesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRecommenderRecipesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRecommenderRecipesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRecommenderRecipes page.
func (p *ListRecommenderRecipesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRecommenderRecipesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRecommenderRecipes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRecommenderRecipesAPIClient is a client that implements the
// ListRecommenderRecipes operation.
type ListRecommenderRecipesAPIClient interface {
	ListRecommenderRecipes(context.Context, *ListRecommenderRecipesInput, ...func(*Options)) (*ListRecommenderRecipesOutput, error)
}

var _ ListRecommenderRecipesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRecommenderRecipes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRecommenderRecipes",
	}
}
