// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API retrieves a list of upload jobs for the specified domain.
func (c *Client) ListUploadJobs(ctx context.Context, params *ListUploadJobsInput, optFns ...func(*Options)) (*ListUploadJobsOutput, error) {
	if params == nil {
		params = &ListUploadJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListUploadJobs", params, optFns, c.addOperationListUploadJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListUploadJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListUploadJobsInput struct {

	// The unique name of the domain to list upload jobs for.
	//
	// This member is required.
	DomainName *string

	// The maximum number of upload jobs to return per page.
	MaxResults *int32

	// The pagination token from the previous call to retrieve the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListUploadJobsOutput struct {

	// The list of upload jobs for the specified domain.
	Items []types.UploadJobItem

	// The pagination token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListUploadJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListUploadJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListUploadJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListUploadJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListUploadJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListUploadJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListUploadJobsPaginatorOptions is the paginator options for ListUploadJobs
type ListUploadJobsPaginatorOptions struct {
	// The maximum number of upload jobs to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListUploadJobsPaginator is a paginator for ListUploadJobs
type ListUploadJobsPaginator struct {
	options   ListUploadJobsPaginatorOptions
	client    ListUploadJobsAPIClient
	params    *ListUploadJobsInput
	nextToken *string
	firstPage bool
}

// NewListUploadJobsPaginator returns a new ListUploadJobsPaginator
func NewListUploadJobsPaginator(client ListUploadJobsAPIClient, params *ListUploadJobsInput, optFns ...func(*ListUploadJobsPaginatorOptions)) *ListUploadJobsPaginator {
	if params == nil {
		params = &ListUploadJobsInput{}
	}

	options := ListUploadJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListUploadJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListUploadJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListUploadJobs page.
func (p *ListUploadJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListUploadJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListUploadJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListUploadJobsAPIClient is a client that implements the ListUploadJobs
// operation.
type ListUploadJobsAPIClient interface {
	ListUploadJobs(context.Context, *ListUploadJobsInput, ...func(*Options)) (*ListUploadJobsOutput, error)
}

var _ ListUploadJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListUploadJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListUploadJobs",
	}
}
