// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of child metadata models for the specified metadata model in the
// database hierarchy.
func (c *Client) DescribeMetadataModelChildren(ctx context.Context, params *DescribeMetadataModelChildrenInput, optFns ...func(*Options)) (*DescribeMetadataModelChildrenOutput, error) {
	if params == nil {
		params = &DescribeMetadataModelChildrenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMetadataModelChildren", params, optFns, c.addOperationDescribeMetadataModelChildrenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMetadataModelChildrenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMetadataModelChildrenInput struct {

	// The migration project name or Amazon Resource Name (ARN).
	//
	// This member is required.
	MigrationProjectIdentifier *string

	// Specifies whether to retrieve metadata from the source or target tree. Valid
	// values: SOURCE | TARGET
	//
	// This member is required.
	Origin types.OriginTypeValue

	// The JSON string that specifies which metadata model's children to retrieve.
	// Only one selection rule with "rule-action": "explicit" can be provided. For more
	// information, see [Selection Rules]in the DMS User Guide.
	//
	// [Selection Rules]: https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.Selections.html
	//
	// This member is required.
	SelectionRules *string

	// Specifies the unique pagination token that indicates where the next page should
	// start. If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string

	// The maximum number of metadata model children to include in the response. If
	// more items exist than the specified MaxRecords value, a marker is included in
	// the response so that the remaining results can be retrieved.
	MaxRecords *int32

	noSmithyDocumentSerde
}

type DescribeMetadataModelChildrenOutput struct {

	// Specifies the unique pagination token that makes it possible to display the
	// next page of metadata model children. If a marker is returned, there are more
	// metadata model children available.
	Marker *string

	// A list of child metadata models.
	MetadataModelChildren []types.MetadataModelReference

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMetadataModelChildrenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMetadataModelChildren{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMetadataModelChildren{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMetadataModelChildren"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeMetadataModelChildrenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMetadataModelChildren(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeMetadataModelChildrenPaginatorOptions is the paginator options for
// DescribeMetadataModelChildren
type DescribeMetadataModelChildrenPaginatorOptions struct {
	// The maximum number of metadata model children to include in the response. If
	// more items exist than the specified MaxRecords value, a marker is included in
	// the response so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMetadataModelChildrenPaginator is a paginator for
// DescribeMetadataModelChildren
type DescribeMetadataModelChildrenPaginator struct {
	options   DescribeMetadataModelChildrenPaginatorOptions
	client    DescribeMetadataModelChildrenAPIClient
	params    *DescribeMetadataModelChildrenInput
	nextToken *string
	firstPage bool
}

// NewDescribeMetadataModelChildrenPaginator returns a new
// DescribeMetadataModelChildrenPaginator
func NewDescribeMetadataModelChildrenPaginator(client DescribeMetadataModelChildrenAPIClient, params *DescribeMetadataModelChildrenInput, optFns ...func(*DescribeMetadataModelChildrenPaginatorOptions)) *DescribeMetadataModelChildrenPaginator {
	if params == nil {
		params = &DescribeMetadataModelChildrenInput{}
	}

	options := DescribeMetadataModelChildrenPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMetadataModelChildrenPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMetadataModelChildrenPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMetadataModelChildren page.
func (p *DescribeMetadataModelChildrenPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMetadataModelChildrenOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeMetadataModelChildren(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeMetadataModelChildrenAPIClient is a client that implements the
// DescribeMetadataModelChildren operation.
type DescribeMetadataModelChildrenAPIClient interface {
	DescribeMetadataModelChildren(context.Context, *DescribeMetadataModelChildrenInput, ...func(*Options)) (*DescribeMetadataModelChildrenOutput, error)
}

var _ DescribeMetadataModelChildrenAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeMetadataModelChildren(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMetadataModelChildren",
	}
}
