// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a paginated list of metadata model creation requests for a migration
// project.
func (c *Client) DescribeMetadataModelCreations(ctx context.Context, params *DescribeMetadataModelCreationsInput, optFns ...func(*Options)) (*DescribeMetadataModelCreationsOutput, error) {
	if params == nil {
		params = &DescribeMetadataModelCreationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMetadataModelCreations", params, optFns, c.addOperationDescribeMetadataModelCreationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMetadataModelCreationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMetadataModelCreationsInput struct {

	// The migration project name or Amazon Resource Name (ARN).
	//
	// This member is required.
	MigrationProjectIdentifier *string

	// Filters applied to the metadata model creation requests described in the form
	// of key-value pairs. The supported filters are request-id and status.
	Filters []types.Filter

	// Specifies the unique pagination token that makes it possible to display the
	// next page of metadata model creation requests. If Marker is returned by a
	// previous response, there are more metadata model creation requests available.
	Marker *string

	// The maximum number of metadata model creation requests to include in the
	// response. If more requests exist than the specified MaxRecords value, a
	// pagination token is provided in the response so that you can retrieve the
	// remaining results.
	MaxRecords *int32

	noSmithyDocumentSerde
}

type DescribeMetadataModelCreationsOutput struct {

	// Specifies the unique pagination token that makes it possible to display the
	// next page of metadata model creation requests. If Marker is returned, there are
	// more metadata model creation requests available.
	Marker *string

	// A list of metadata model creation requests. The ExportSqlDetails field will
	// never be populated for the DescribeMetadataModelCreations operation.
	Requests []types.SchemaConversionRequest

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMetadataModelCreationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMetadataModelCreations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMetadataModelCreations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMetadataModelCreations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeMetadataModelCreationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMetadataModelCreations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeMetadataModelCreationsPaginatorOptions is the paginator options for
// DescribeMetadataModelCreations
type DescribeMetadataModelCreationsPaginatorOptions struct {
	// The maximum number of metadata model creation requests to include in the
	// response. If more requests exist than the specified MaxRecords value, a
	// pagination token is provided in the response so that you can retrieve the
	// remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMetadataModelCreationsPaginator is a paginator for
// DescribeMetadataModelCreations
type DescribeMetadataModelCreationsPaginator struct {
	options   DescribeMetadataModelCreationsPaginatorOptions
	client    DescribeMetadataModelCreationsAPIClient
	params    *DescribeMetadataModelCreationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeMetadataModelCreationsPaginator returns a new
// DescribeMetadataModelCreationsPaginator
func NewDescribeMetadataModelCreationsPaginator(client DescribeMetadataModelCreationsAPIClient, params *DescribeMetadataModelCreationsInput, optFns ...func(*DescribeMetadataModelCreationsPaginatorOptions)) *DescribeMetadataModelCreationsPaginator {
	if params == nil {
		params = &DescribeMetadataModelCreationsInput{}
	}

	options := DescribeMetadataModelCreationsPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMetadataModelCreationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMetadataModelCreationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMetadataModelCreations page.
func (p *DescribeMetadataModelCreationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMetadataModelCreationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeMetadataModelCreations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeMetadataModelCreationsAPIClient is a client that implements the
// DescribeMetadataModelCreations operation.
type DescribeMetadataModelCreationsAPIClient interface {
	DescribeMetadataModelCreations(context.Context, *DescribeMetadataModelCreationsInput, ...func(*Options)) (*DescribeMetadataModelCreationsOutput, error)
}

var _ DescribeMetadataModelCreationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeMetadataModelCreations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMetadataModelCreations",
	}
}
