// Code generated by smithy-go-codegen DO NOT EDIT.

package datapipeline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datapipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Task runners call PollForTask to receive a task to perform from AWS Data
// Pipeline. The task runner specifies which tasks it can perform by setting a
// value for the workerGroup parameter. The task returned can come from any of the
// pipelines that match the workerGroup value passed in by the task runner and
// that was launched using the IAM user credentials specified by the task runner.
//
// If tasks are ready in the work queue, PollForTask returns a response
// immediately. If no tasks are available in the queue, PollForTask uses
// long-polling and holds on to a poll connection for up to a 90 seconds, during
// which time the first newly scheduled task is handed to the task runner. To
// accomodate this, set the socket timeout in your task runner to 90 seconds. The
// task runner should not call PollForTask again on the same workerGroup until it
// receives a response, and this can take up to 90 seconds.
//
// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target:
// DataPipeline.PollForTask Content-Length: 59 Host:
// datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT
// Authorization: AuthParams
//
// {"workerGroup": "MyworkerGroup", "hostname": "example.com"}
//
// x-amzn-RequestId: 41c713d2-0775-11e2-af6f-6bc7a6be60d9 Content-Type:
// application/x-amz-json-1.1 Content-Length: 39 Date: Mon, 12 Nov 2012 17:50:53
// GMT
//
// {"taskObject": {"attemptId": "@SayHello_2012-12-12T00:00:00_Attempt=1",
// "objects": {"@SayHello_2012-12-12T00:00:00_Attempt=1": {"fields": [ {"key":
// "@componentParent", "refValue": "SayHello"}, {"key": "@scheduledStartTime",
// "stringValue": "2012-12-12T00:00:00"}, {"key": "parent", "refValue":
// "SayHello"}, {"key": "@sphere", "stringValue": "ATTEMPT"}, {"key":
// "workerGroup", "stringValue": "workerGroup"}, {"key": "@instanceParent",
// "refValue": "@SayHello_2012-12-12T00:00:00"}, {"key": "type", "stringValue":
// "ShellCommandActivity"}, {"key": "@status", "stringValue":
// "WAITING_FOR_RUNNER"}, {"key": "@version", "stringValue": "1"}, {"key":
// "schedule", "refValue": "Schedule"}, {"key": "@actualStartTime", "stringValue":
// "2012-12-13T01:40:50"}, {"key": "command", "stringValue": "echo hello"}, {"key":
// "@scheduledEndTime", "stringValue": "2012-12-12T01:00:00"}, {"key":
// "@activeInstances", "refValue": "@SayHello_2012-12-12T00:00:00"}, {"key":
// "@pipelineId", "stringValue": "df-0937003356ZJEXAMPLE"} ], "id":
// "@SayHello_2012-12-12T00:00:00_Attempt=1", "name":
// "@SayHello_2012-12-12T00:00:00_Attempt=1"} }, "pipelineId":
// "df-0937003356ZJEXAMPLE", "taskId":
// "2xaM4wRs5zOsIH+g9U3oVHfAgAlbSqU6XduncB0HhZ3xMnmvfePZPn4dIbYXHyWyRK+cU15MqDHwdrvftx/4wv+sNS4w34vJfv7QA9aOoOazW28l1GYSb2ZRR0N0paiQp+d1MhSKo10hOTWOsVK5S5Lnx9Qm6omFgXHyIvZRIvTlrQMpr1xuUrflyGOfbFOGpOLpvPE172MYdqpZKnbSS4TcuqgQKSWV2833fEubI57DPOP7ghWa2TcYeSIv4pdLYG53fTuwfbnbdc98g2LNUQzSVhSnt7BoqyNwht2aQ6b/UHg9A80+KVpuXuqmz3m1MXwHFgxjdmuesXNOrrlGpeLCcRWD+aGo0RN1NqhQRzNAig8V4GlaPTQzMsRCljKqvrIyAoP3Tt2XEGsHkkQo12rEX8Z90957XX2qKRwhruwYzqGkSLWjINoLdAxUJdpRXRc5DJTrBd3D5mdzn7kY1l7NEh4kFHJDt3Cx4Z3Mk8MYCACyCk/CEyy9DwuPi66cLz0NBcgbCM5LKjTBOwo1m+am+pvM1kSposE9FPP1+RFGb8k6jQBTJx3TRz1yKilnGXQTZ5xvdOFpJrklIT0OXP1MG3+auM9FlJA+1dX90QoNJE5z7axmK//MOGXUdkqFe2kiDkorqjxwDvc0Js9pVKfKvAmW8YqUbmI9l0ERpWCXXnLVHNmPWz3jaPY+OBAmuJWDmxB/Z8p94aEDg4BVXQ7LvsKQ3DLYhaB7yJ390CJT+i0mm+EBqY60V6YikPSWDFrYQ/NPi2b1DgE19mX8zHqw8qprIl4yh1Ckx2Iige4En/N5ktOoIxnASxAw/TzcE2skxdw5KlHDF+UTj71m16CR/dIaKlXijlfNlNzUBo/bNSadCQn3G5NoO501wPKI:XO50TgDNyo8EXAMPLE/g==:1"}
// }
func (c *Client) PollForTask(ctx context.Context, params *PollForTaskInput, optFns ...func(*Options)) (*PollForTaskOutput, error) {
	if params == nil {
		params = &PollForTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PollForTask", params, optFns, c.addOperationPollForTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PollForTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the parameters for PollForTask.
type PollForTaskInput struct {

	// The type of task the task runner is configured to accept and process. The
	// worker group is set as a field on objects in the pipeline when they are created.
	// You can only specify a single value for workerGroup in the call to PollForTask .
	// There are no wildcard values permitted in workerGroup ; the string must be an
	// exact, case-sensitive, match.
	//
	// This member is required.
	WorkerGroup *string

	// The public DNS name of the calling task runner.
	Hostname *string

	// Identity information for the EC2 instance that is hosting the task runner. You
	// can get this value from the instance using
	// http://169.254.169.254/latest/meta-data/instance-id . For more information, see [Instance Metadata]
	// in the Amazon Elastic Compute Cloud User Guide. Passing in this value proves
	// that your task runner is running on an EC2 instance, and ensures the proper AWS
	// Data Pipeline service charges are applied to your pipeline.
	//
	// [Instance Metadata]: http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html
	InstanceIdentity *types.InstanceIdentity

	noSmithyDocumentSerde
}

// Contains the output of PollForTask.
type PollForTaskOutput struct {

	// The information needed to complete the task that is being assigned to the task
	// runner. One of the fields returned in this object is taskId , which contains an
	// identifier for the task being assigned. The calling task runner uses taskId in
	// subsequent calls to ReportTaskProgressand SetTaskStatus.
	TaskObject *types.TaskObject

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPollForTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPollForTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPollForTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PollForTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPollForTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPollForTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPollForTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PollForTask",
	}
}
