// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides details about how an DataSync transfer location for a Server Message
// Block (SMB) file server is configured.
func (c *Client) DescribeLocationSmb(ctx context.Context, params *DescribeLocationSmbInput, optFns ...func(*Options)) (*DescribeLocationSmbOutput, error) {
	if params == nil {
		params = &DescribeLocationSmbInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeLocationSmb", params, optFns, c.addOperationDescribeLocationSmbMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeLocationSmbOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// DescribeLocationSmbRequest
type DescribeLocationSmbInput struct {

	// Specifies the Amazon Resource Name (ARN) of the SMB location that you want
	// information about.
	//
	// This member is required.
	LocationArn *string

	noSmithyDocumentSerde
}

// DescribeLocationSmbResponse
type DescribeLocationSmbOutput struct {

	// The ARNs of the DataSync agents that can connect with your SMB file server.
	AgentArns []string

	// The authentication protocol that DataSync uses to connect to your SMB file
	// server.
	AuthenticationType types.SmbAuthenticationType

	// The time that the SMB location was created.
	CreationTime *time.Time

	// The IPv4 or IPv6 addresses for the DNS servers that your SMB file server
	// belongs to. This element applies only if AuthenticationType is set to KERBEROS .
	DnsIpAddresses []string

	// The name of the Windows domain that the SMB file server belongs to. This
	// element applies only if AuthenticationType is set to NTLM .
	Domain *string

	// The Kerberos principal that has permission to access the files, folders, and
	// file metadata in your SMB file server.
	KerberosPrincipal *string

	// The ARN of the SMB location.
	LocationArn *string

	// The URI of the SMB location.
	LocationUri *string

	// The SMB protocol version that DataSync uses to access your SMB file server.
	MountOptions *types.SmbMountOptions

	// The user that can mount and access the files, folders, and file metadata in
	// your SMB file server. This element applies only if AuthenticationType is set to
	// NTLM .
	User *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeLocationSmbMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeLocationSmb{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeLocationSmb{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeLocationSmb"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeLocationSmbValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeLocationSmb(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeLocationSmb(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeLocationSmb",
	}
}
