// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the details of the account pool.
func (c *Client) GetAccountPool(ctx context.Context, params *GetAccountPoolInput, optFns ...func(*Options)) (*GetAccountPoolOutput, error) {
	if params == nil {
		params = &GetAccountPoolInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAccountPool", params, optFns, c.addOperationGetAccountPoolMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAccountPoolOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAccountPoolInput struct {

	// The ID of the domain in which the account pool lives whose details are to be
	// displayed.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the account pool whose details are to be displayed.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetAccountPoolOutput struct {

	// The source of accounts for the account pool. In the current release, it's
	// either a static list of accounts provided by the customer or a custom Amazon Web
	// Services Lambda handler.
	//
	// This member is required.
	AccountSource types.AccountSource

	// The user who created the account pool.
	//
	// This member is required.
	CreatedBy *string

	// The timestamp at which the account pool was created.
	CreatedAt *time.Time

	// The description of the account pool.
	Description *string

	// The ID of the domain in which the account pool lives whose details are to be
	// displayed.
	DomainId *string

	// The domain unit ID of the account pool.
	DomainUnitId *string

	// The ID of the account pool.
	Id *string

	// The timestamp at which the account pool was last updated.
	LastUpdatedAt *time.Time

	// The name of the account pool.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	ResolutionStrategy types.ResolutionStrategy

	// The user who last updated the account pool.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAccountPoolMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAccountPool"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAccountPoolValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAccountPool(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAccountPool(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAccountPool",
	}
}
