// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the data lineage node.
func (c *Client) GetLineageNode(ctx context.Context, params *GetLineageNodeInput, optFns ...func(*Options)) (*GetLineageNodeOutput, error) {
	if params == nil {
		params = &GetLineageNodeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetLineageNode", params, optFns, c.addOperationGetLineageNodeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetLineageNodeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetLineageNodeInput struct {

	// The ID of the domain in which you want to get the data lineage node.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the data lineage node that you want to get.
	//
	// Both, a lineage node identifier generated by Amazon DataZone and a
	// sourceIdentifier of the lineage node are supported. If sourceIdentifier is
	// greater than 1800 characters, you can use lineage node identifier generated by
	// Amazon DataZone to get the node details.
	//
	// This member is required.
	Identifier *string

	// The event time stamp for which you want to get the data lineage node.
	EventTimestamp *time.Time

	noSmithyDocumentSerde
}

type GetLineageNodeOutput struct {

	// The ID of the domain where you're getting the data lineage node.
	//
	// This member is required.
	DomainId *string

	// The ID of the data lineage node.
	//
	// This member is required.
	Id *string

	// The name of the type of the specified data lineage node.
	//
	// This member is required.
	TypeName *string

	// The timestamp at which the data lineage node was created.
	CreatedAt *time.Time

	// The user who created the data lineage node.
	CreatedBy *string

	// The description of the data lineage node.
	Description *string

	// The downsteam nodes of the specified data lineage node.
	DownstreamNodes []types.LineageNodeReference

	// The timestamp of the event described in the data lineage node.
	EventTimestamp *time.Time

	// The metadata of the specified data lineage node.
	FormsOutput []types.FormOutput

	// The name of the data lineage node.
	Name *string

	// The source identifier of the data lineage node.
	SourceIdentifier *string

	// The revision type of the specified data lineage node.
	TypeRevision *string

	// The timestamp at which the data lineage node was updated.
	UpdatedAt *time.Time

	// The user who updated the data lineage node.
	UpdatedBy *string

	// The upstream nodes of the specified data lineage node.
	UpstreamNodes []types.LineageNodeReference

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetLineageNodeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetLineageNode{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetLineageNode{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetLineageNode"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetLineageNodeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetLineageNode(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetLineageNode(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetLineageNode",
	}
}
