// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists project profiles.
func (c *Client) ListProjectProfiles(ctx context.Context, params *ListProjectProfilesInput, optFns ...func(*Options)) (*ListProjectProfilesOutput, error) {
	if params == nil {
		params = &ListProjectProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProjectProfiles", params, optFns, c.addOperationListProjectProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProjectProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProjectProfilesInput struct {

	// The ID of the domain where you want to list project profiles.
	//
	// This member is required.
	DomainIdentifier *string

	// The maximum number of project profiles to return in a single call to
	// ListProjectProfiles. When the number of project profiles to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListProjectProfiles to list the next set of
	// project profiles.
	MaxResults *int32

	// The name of a project profile.
	Name *string

	// When the number of project profiles is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of project profiles, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListProjectProfiles to list the next set of project profiles.
	NextToken *string

	// Specifies by what to sort project profiles.
	SortBy types.SortFieldProject

	// Specifies the sort order of the project profiles.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListProjectProfilesOutput struct {

	// The results of the ListProjectProfiles action.
	Items []types.ProjectProfileSummary

	// When the number of project profiles is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of project profiles, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListProjectProfiles to list the next set of project profiles.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProjectProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListProjectProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListProjectProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProjectProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListProjectProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProjectProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListProjectProfilesPaginatorOptions is the paginator options for
// ListProjectProfiles
type ListProjectProfilesPaginatorOptions struct {
	// The maximum number of project profiles to return in a single call to
	// ListProjectProfiles. When the number of project profiles to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListProjectProfiles to list the next set of
	// project profiles.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProjectProfilesPaginator is a paginator for ListProjectProfiles
type ListProjectProfilesPaginator struct {
	options   ListProjectProfilesPaginatorOptions
	client    ListProjectProfilesAPIClient
	params    *ListProjectProfilesInput
	nextToken *string
	firstPage bool
}

// NewListProjectProfilesPaginator returns a new ListProjectProfilesPaginator
func NewListProjectProfilesPaginator(client ListProjectProfilesAPIClient, params *ListProjectProfilesInput, optFns ...func(*ListProjectProfilesPaginatorOptions)) *ListProjectProfilesPaginator {
	if params == nil {
		params = &ListProjectProfilesInput{}
	}

	options := ListProjectProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProjectProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProjectProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProjectProfiles page.
func (p *ListProjectProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProjectProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProjectProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProjectProfilesAPIClient is a client that implements the
// ListProjectProfiles operation.
type ListProjectProfilesAPIClient interface {
	ListProjectProfiles(context.Context, *ListProjectProfilesInput, ...func(*Options)) (*ListProjectProfilesOutput, error)
}

var _ ListProjectProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProjectProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProjectProfiles",
	}
}
