// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for assets in Amazon DataZone.
//
// Search in Amazon DataZone is a powerful capability that enables users to
// discover and explore data assets, glossary terms, and data products across their
// organization. It provides both basic and advanced search functionality, allowing
// users to find resources based on names, descriptions, metadata, and other
// attributes. Search can be scoped to specific types of resources (like assets,
// glossary terms, or data products) and can be filtered using various criteria
// such as creation date, owner, or status. The search functionality is essential
// for making the wealth of data resources in an organization discoverable and
// usable, helping users find the right data for their needs quickly and
// efficiently.
//
// Many search commands in Amazon DataZone are paginated, including search and
// search-types . When the result set is large, Amazon DataZone returns a nextToken
// in the response. This token can be used to retrieve the next page of results.
//
// Prerequisites:
//
//   - The --domain-identifier must refer to an existing Amazon DataZone domain.
//
//   - --search-scope must be one of: ASSET, GLOSSARY_TERM, DATA_PRODUCT, or
//     GLOSSARY.
//
//   - The user must have search permissions in the specified domain.
//
//   - If using --filters, ensure that the JSON is well-formed and that each
//     filter includes valid attribute and value keys.
//
//   - For paginated results, be prepared to use --next-token to fetch additional
//     pages.
func (c *Client) Search(ctx context.Context, params *SearchInput, optFns ...func(*Options)) (*SearchOutput, error) {
	if params == nil {
		params = &SearchInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Search", params, optFns, c.addOperationSearchMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchInput struct {

	// The identifier of the Amazon DataZone domain.
	//
	// This member is required.
	DomainIdentifier *string

	// The scope of the search.
	//
	// This member is required.
	SearchScope types.InventorySearchScope

	// Specifies additional attributes for the Search action.
	AdditionalAttributes []types.SearchOutputAdditionalAttribute

	// Specifies the search filters.
	Filters types.FilterClause

	// The maximum number of results to return in a single call to Search . When the
	// number of results to be listed is greater than the value of MaxResults , the
	// response contains a NextToken value that you can use in a subsequent call to
	// Search to list the next set of results.
	MaxResults *int32

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to Search
	// to list the next set of results.
	NextToken *string

	// The identifier of the owning project specified for the search.
	OwningProjectIdentifier *string

	// The details of the search.
	SearchIn []types.SearchInItem

	// Specifies the text for which to search.
	SearchText *string

	// Specifies the way in which the search results are to be sorted.
	Sort *types.SearchSort

	noSmithyDocumentSerde
}

type SearchOutput struct {

	// The results of the Search action.
	Items []types.SearchInventoryResultItem

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to Search
	// to list the next set of results.
	NextToken *string

	// Total number of search results.
	TotalMatchCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearch{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearch{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Search"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearch(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchPaginatorOptions is the paginator options for Search
type SearchPaginatorOptions struct {
	// The maximum number of results to return in a single call to Search . When the
	// number of results to be listed is greater than the value of MaxResults , the
	// response contains a NextToken value that you can use in a subsequent call to
	// Search to list the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchPaginator is a paginator for Search
type SearchPaginator struct {
	options   SearchPaginatorOptions
	client    SearchAPIClient
	params    *SearchInput
	nextToken *string
	firstPage bool
}

// NewSearchPaginator returns a new SearchPaginator
func NewSearchPaginator(client SearchAPIClient, params *SearchInput, optFns ...func(*SearchPaginatorOptions)) *SearchPaginator {
	if params == nil {
		params = &SearchInput{}
	}

	options := SearchPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next Search page.
func (p *SearchPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.Search(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchAPIClient is a client that implements the Search operation.
type SearchAPIClient interface {
	Search(context.Context, *SearchInput, ...func(*Options)) (*SearchOutput, error)
}

var _ SearchAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearch(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Search",
	}
}
