// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the domain unit.
func (c *Client) UpdateDomainUnit(ctx context.Context, params *UpdateDomainUnitInput, optFns ...func(*Options)) (*UpdateDomainUnitOutput, error) {
	if params == nil {
		params = &UpdateDomainUnitInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDomainUnit", params, optFns, c.addOperationUpdateDomainUnitMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDomainUnitOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDomainUnitInput struct {

	// The ID of the domain where you want to update a domain unit.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the domain unit that you want to update.
	//
	// This member is required.
	Identifier *string

	// The description of the domain unit that you want to update.
	Description *string

	// The name of the domain unit that you want to update.
	Name *string

	noSmithyDocumentSerde
}

type UpdateDomainUnitOutput struct {

	// The ID of the domain where you want to update the domain unit.
	//
	// This member is required.
	DomainId *string

	// The ID of the domain unit that you want to update.
	//
	// This member is required.
	Id *string

	// The name of the domain unit that you want to update.
	//
	// This member is required.
	Name *string

	// The owners of the domain unit that you want to update.
	//
	// This member is required.
	Owners []types.DomainUnitOwnerProperties

	// The time stamp at which the domain unit that you want to update was created.
	CreatedAt *time.Time

	// The user who created the domain unit that you want to update.
	CreatedBy *string

	// The description of the domain unit that you want to update.
	Description *string

	// The timestamp at which the domain unit was last updated.
	LastUpdatedAt *time.Time

	// The user who last updated the domain unit.
	LastUpdatedBy *string

	// The ID of the parent domain unit.
	ParentDomainUnitId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDomainUnitMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDomainUnit{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDomainUnit{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDomainUnit"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDomainUnitValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDomainUnit(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDomainUnit(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDomainUnit",
	}
}
