// Code generated by smithy-go-codegen DO NOT EDIT.

package devicefarm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/devicefarm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Specifies and starts a remote access session.
func (c *Client) CreateRemoteAccessSession(ctx context.Context, params *CreateRemoteAccessSessionInput, optFns ...func(*Options)) (*CreateRemoteAccessSessionOutput, error) {
	if params == nil {
		params = &CreateRemoteAccessSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRemoteAccessSession", params, optFns, c.addOperationCreateRemoteAccessSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRemoteAccessSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Creates and submits a request to start a remote access session.
type CreateRemoteAccessSessionInput struct {

	// The ARN of the device for which you want to create a remote access session.
	//
	// This member is required.
	DeviceArn *string

	// The Amazon Resource Name (ARN) of the project for which you want to create a
	// remote access session.
	//
	// This member is required.
	ProjectArn *string

	// The Amazon Resource Name (ARN) of the app to create the remote access session.
	AppArn *string

	// The configuration information for the remote access session request.
	Configuration *types.CreateRemoteAccessSessionConfiguration

	// The Amazon Resource Name (ARN) of the device instance for which you want to
	// create a remote access session.
	InstanceArn *string

	// The interaction mode of the remote access session. Changing the interactive
	// mode of remote access sessions is no longer available.
	//
	// Deprecated: Changing the interactive mode of Remote Access sessions is no
	// longer available.
	InteractionMode types.InteractionMode

	// The name of the remote access session to create.
	Name *string

	// When set to true , for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information on how Device Farm modifies your uploads during tests, see [Do you modify my app?]
	//
	// [Do you modify my app?]: http://aws.amazon.com/device-farm/faqs/
	SkipAppResign *bool

	noSmithyDocumentSerde
}

// Represents the server response from a request to create a remote access session.
type CreateRemoteAccessSessionOutput struct {

	// A container that describes the remote access session when the request to create
	// a remote access session is sent.
	RemoteAccessSession *types.RemoteAccessSession

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRemoteAccessSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateRemoteAccessSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateRemoteAccessSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRemoteAccessSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRemoteAccessSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRemoteAccessSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRemoteAccessSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRemoteAccessSession",
	}
}
