// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of an existing hybrid directory. You can recover
// hybrid directory administrator account or modify self-managed instance settings.
//
// Updates are applied asynchronously. Use DescribeHybridADUpdate to monitor the progress of
// configuration changes.
//
// The InstanceIds must have a one-to-one correspondence with CustomerDnsIps ,
// meaning that if the IP address for instance i-10243410 is 10.24.34.100 and the
// IP address for instance i-10243420 is 10.24.34.200, then the input arrays must
// maintain the same order relationship, either [10.24.34.100, 10.24.34.200] paired
// with [i-10243410, i-10243420] or [10.24.34.200, 10.24.34.100] paired with
// [i-10243420, i-10243410].
//
// You must provide at least one update to UpdateHybridADRequest$HybridAdministratorAccountUpdate or UpdateHybridADRequest$SelfManagedInstancesSettings.
func (c *Client) UpdateHybridAD(ctx context.Context, params *UpdateHybridADInput, optFns ...func(*Options)) (*UpdateHybridADOutput, error) {
	if params == nil {
		params = &UpdateHybridADInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateHybridAD", params, optFns, c.addOperationUpdateHybridADMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateHybridADOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateHybridADInput struct {

	// The identifier of the hybrid directory to update.
	//
	// This member is required.
	DirectoryId *string

	// We create a hybrid directory administrator account when we create a hybrid
	// directory. Use HybridAdministratorAccountUpdate to recover the hybrid directory
	// administrator account if you have deleted it.
	//
	// To recover your hybrid directory administrator account, we need temporary
	// access to a user in your self-managed AD with administrator permissions in the
	// form of a secret from Amazon Web Services Secrets Manager. We use these
	// credentials once during recovery and don't store them.
	//
	// If your hybrid directory administrator account exists, then you don’t need to
	// use HybridAdministratorAccountUpdate , even if you have updated your
	// self-managed AD administrator user.
	HybridAdministratorAccountUpdate *types.HybridAdministratorAccountUpdate

	// Updates to the self-managed AD configuration, including DNS server IP addresses
	// and Amazon Web Services System Manager managed node identifiers.
	SelfManagedInstancesSettings *types.HybridCustomerInstancesSettings

	noSmithyDocumentSerde
}

type UpdateHybridADOutput struct {

	// The identifier of the assessment performed to validate the update
	// configuration. This assessment ensures the updated settings are compatible with
	// your environment.
	AssessmentId *string

	// The identifier of the updated hybrid directory.
	DirectoryId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateHybridADMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateHybridAD{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateHybridAD{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateHybridAD"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateHybridADValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateHybridAD(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateHybridAD(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateHybridAD",
	}
}
