// Code generated by smithy-go-codegen DO NOT EDIT.

package docdbelastic

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/docdbelastic/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of all maintenance actions that are pending.
func (c *Client) ListPendingMaintenanceActions(ctx context.Context, params *ListPendingMaintenanceActionsInput, optFns ...func(*Options)) (*ListPendingMaintenanceActionsOutput, error) {
	if params == nil {
		params = &ListPendingMaintenanceActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPendingMaintenanceActions", params, optFns, c.addOperationListPendingMaintenanceActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPendingMaintenanceActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPendingMaintenanceActionsInput struct {

	// The maximum number of results to include in the response. If more records exist
	// than the specified maxResults value, a pagination token (marker) is included in
	// the response so that the remaining results can be retrieved.
	MaxResults *int32

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to the
	// value specified by maxResults .
	NextToken *string

	noSmithyDocumentSerde
}

type ListPendingMaintenanceActionsOutput struct {

	// Provides information about a pending maintenance action for a resource.
	//
	// This member is required.
	ResourcePendingMaintenanceActions []types.ResourcePendingMaintenanceAction

	// An optional pagination token provided by a previous request. If this parameter
	// is displayed, the responses will include only records beyond the marker, up to
	// the value specified by maxResults .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPendingMaintenanceActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPendingMaintenanceActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPendingMaintenanceActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPendingMaintenanceActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPendingMaintenanceActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPendingMaintenanceActionsPaginatorOptions is the paginator options for
// ListPendingMaintenanceActions
type ListPendingMaintenanceActionsPaginatorOptions struct {
	// The maximum number of results to include in the response. If more records exist
	// than the specified maxResults value, a pagination token (marker) is included in
	// the response so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPendingMaintenanceActionsPaginator is a paginator for
// ListPendingMaintenanceActions
type ListPendingMaintenanceActionsPaginator struct {
	options   ListPendingMaintenanceActionsPaginatorOptions
	client    ListPendingMaintenanceActionsAPIClient
	params    *ListPendingMaintenanceActionsInput
	nextToken *string
	firstPage bool
}

// NewListPendingMaintenanceActionsPaginator returns a new
// ListPendingMaintenanceActionsPaginator
func NewListPendingMaintenanceActionsPaginator(client ListPendingMaintenanceActionsAPIClient, params *ListPendingMaintenanceActionsInput, optFns ...func(*ListPendingMaintenanceActionsPaginatorOptions)) *ListPendingMaintenanceActionsPaginator {
	if params == nil {
		params = &ListPendingMaintenanceActionsInput{}
	}

	options := ListPendingMaintenanceActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPendingMaintenanceActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPendingMaintenanceActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPendingMaintenanceActions page.
func (p *ListPendingMaintenanceActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPendingMaintenanceActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPendingMaintenanceActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPendingMaintenanceActionsAPIClient is a client that implements the
// ListPendingMaintenanceActions operation.
type ListPendingMaintenanceActionsAPIClient interface {
	ListPendingMaintenanceActions(context.Context, *ListPendingMaintenanceActionsInput, ...func(*Options)) (*ListPendingMaintenanceActionsOutput, error)
}

var _ ListPendingMaintenanceActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPendingMaintenanceActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPendingMaintenanceActions",
	}
}
