// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more IPAM prefix list resolver Targets. Use this operation to
// view the configuration and status of resolver targets.
func (c *Client) DescribeIpamPrefixListResolverTargets(ctx context.Context, params *DescribeIpamPrefixListResolverTargetsInput, optFns ...func(*Options)) (*DescribeIpamPrefixListResolverTargetsOutput, error) {
	if params == nil {
		params = &DescribeIpamPrefixListResolverTargetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeIpamPrefixListResolverTargets", params, optFns, c.addOperationDescribeIpamPrefixListResolverTargetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeIpamPrefixListResolverTargetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeIpamPrefixListResolverTargetsInput struct {

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters to limit the results.
	Filters []types.Filter

	// The ID of the IPAM prefix list resolver to filter targets by. Only targets
	// associated with this resolver will be returned.
	IpamPrefixListResolverId *string

	// The IDs of the IPAM prefix list resolver Targets to describe. If not specified,
	// all targets in your account are described.
	IpamPrefixListResolverTargetIds []string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeIpamPrefixListResolverTargetsOutput struct {

	// Information about the IPAM prefix list resolver Targets.
	IpamPrefixListResolverTargets []types.IpamPrefixListResolverTarget

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeIpamPrefixListResolverTargetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeIpamPrefixListResolverTargets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeIpamPrefixListResolverTargets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeIpamPrefixListResolverTargets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeIpamPrefixListResolverTargets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeIpamPrefixListResolverTargetsPaginatorOptions is the paginator options
// for DescribeIpamPrefixListResolverTargets
type DescribeIpamPrefixListResolverTargetsPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeIpamPrefixListResolverTargetsPaginator is a paginator for
// DescribeIpamPrefixListResolverTargets
type DescribeIpamPrefixListResolverTargetsPaginator struct {
	options   DescribeIpamPrefixListResolverTargetsPaginatorOptions
	client    DescribeIpamPrefixListResolverTargetsAPIClient
	params    *DescribeIpamPrefixListResolverTargetsInput
	nextToken *string
	firstPage bool
}

// NewDescribeIpamPrefixListResolverTargetsPaginator returns a new
// DescribeIpamPrefixListResolverTargetsPaginator
func NewDescribeIpamPrefixListResolverTargetsPaginator(client DescribeIpamPrefixListResolverTargetsAPIClient, params *DescribeIpamPrefixListResolverTargetsInput, optFns ...func(*DescribeIpamPrefixListResolverTargetsPaginatorOptions)) *DescribeIpamPrefixListResolverTargetsPaginator {
	if params == nil {
		params = &DescribeIpamPrefixListResolverTargetsInput{}
	}

	options := DescribeIpamPrefixListResolverTargetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeIpamPrefixListResolverTargetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeIpamPrefixListResolverTargetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeIpamPrefixListResolverTargets page.
func (p *DescribeIpamPrefixListResolverTargetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeIpamPrefixListResolverTargetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeIpamPrefixListResolverTargets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeIpamPrefixListResolverTargetsAPIClient is a client that implements the
// DescribeIpamPrefixListResolverTargets operation.
type DescribeIpamPrefixListResolverTargetsAPIClient interface {
	DescribeIpamPrefixListResolverTargets(context.Context, *DescribeIpamPrefixListResolverTargetsInput, ...func(*Options)) (*DescribeIpamPrefixListResolverTargetsOutput, error)
}

var _ DescribeIpamPrefixListResolverTargetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeIpamPrefixListResolverTargets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeIpamPrefixListResolverTargets",
	}
}
