// Code generated by smithy-go-codegen DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Express service that simplifies deploying containerized web
// applications on Amazon ECS with managed Amazon Web Services infrastructure. This
// operation provisions and configures Application Load Balancers, target groups,
// security groups, and auto-scaling policies automatically.
//
// Specify a primary container configuration with your application image and basic
// settings. Amazon ECS creates the necessary Amazon Web Services resources for
// traffic distribution, health monitoring, network access control, and capacity
// management.
//
// Provide an execution role for task operations and an infrastructure role for
// managing Amazon Web Services resources on your behalf.
func (c *Client) CreateExpressGatewayService(ctx context.Context, params *CreateExpressGatewayServiceInput, optFns ...func(*Options)) (*CreateExpressGatewayServiceOutput, error) {
	if params == nil {
		params = &CreateExpressGatewayServiceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateExpressGatewayService", params, optFns, c.addOperationCreateExpressGatewayServiceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateExpressGatewayServiceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateExpressGatewayServiceInput struct {

	// The Amazon Resource Name (ARN) of the task execution role that grants the
	// Amazon ECS container agent permission to make Amazon Web Services API calls on
	// your behalf. This role is required for Amazon ECS to pull container images from
	// Amazon ECR, send container logs to Amazon CloudWatch Logs, and retrieve
	// sensitive data from Amazon Web Services Systems Manager Parameter Store or
	// Amazon Web Services Secrets Manager.
	//
	// The execution role must include the AmazonECSTaskExecutionRolePolicy managed
	// policy or equivalent permissions. For Express services, this role is used during
	// task startup and runtime for container management operations.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The Amazon Resource Name (ARN) of the infrastructure role that grants Amazon
	// ECS permission to create and manage Amazon Web Services resources on your behalf
	// for the Express service. This role is used to provision and manage Application
	// Load Balancers, target groups, security groups, auto-scaling policies, and other
	// Amazon Web Services infrastructure components.
	//
	// The infrastructure role must include permissions for Elastic Load Balancing,
	// Application Auto Scaling, Amazon EC2 (for security groups), and other services
	// required for managed infrastructure. This role is only used during Express
	// service creation, updates, and deletion operations.
	//
	// This member is required.
	InfrastructureRoleArn *string

	// The primary container configuration for the Express service. This defines the
	// main application container that will receive traffic from the Application Load
	// Balancer.
	//
	// The primary container must specify at minimum a container image. You can also
	// configure the container port (defaults to 80), logging configuration,
	// environment variables, secrets, and startup commands. The container image can be
	// from Amazon ECR, Docker Hub, or any other container registry accessible to your
	// execution role.
	//
	// This member is required.
	PrimaryContainer *types.ExpressGatewayContainer

	// The short name or full Amazon Resource Name (ARN) of the cluster on which to
	// create the Express service. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string

	// The number of CPU units used by the task. This parameter determines the CPU
	// allocation for each task in the Express service. The default value for an
	// Express service is 256 (.25 vCPU).
	Cpu *string

	// The path on the container that the Application Load Balancer uses for health
	// checks. This should be a valid HTTP endpoint that returns a successful response
	// (HTTP 200) when the application is healthy.
	//
	// If not specified, the default health check path is /ping . The health check path
	// must start with a forward slash and can include query parameters. Examples:
	// /health , /api/status , /ping?format=json .
	HealthCheckPath *string

	// The amount of memory (in MiB) used by the task. This parameter determines the
	// memory allocation for each task in the Express service. The default value for an
	// express service is 512 MiB.
	Memory *string

	// The network configuration for the Express service tasks. This specifies the VPC
	// subnets and security groups for the tasks.
	//
	// For Express services, you can specify custom security groups and subnets. If
	// not provided, Amazon ECS will use the default VPC configuration and create
	// appropriate security groups automatically. The network configuration determines
	// how your service integrates with your VPC and what network access it has.
	NetworkConfiguration *types.ExpressGatewayServiceNetworkConfiguration

	// The auto-scaling configuration for the Express service. This defines how the
	// service automatically adjusts the number of running tasks based on demand.
	//
	// You can specify the minimum and maximum number of tasks, the scaling metric
	// (CPU utilization, memory utilization, or request count per target), and the
	// target value for the metric. If not specified, the default target value for an
	// Express service is 60.
	ScalingTarget *types.ExpressGatewayScalingTarget

	// The name of the Express service. This name must be unique within the specified
	// cluster and can contain up to 255 letters (uppercase and lowercase), numbers,
	// underscores, and hyphens. The name is used to identify the service in the Amazon
	// ECS console and API operations.
	//
	// If you don't specify a service name, Amazon ECS generates a unique name for the
	// service. The service name becomes part of the service ARN and cannot be changed
	// after the service is created.
	ServiceName *string

	// The metadata that you apply to the Express service to help categorize and
	// organize it. Each tag consists of a key and an optional value. You can apply up
	// to 50 tags to a service.
	Tags []types.Tag

	// The Amazon Resource Name (ARN) of the IAM role that containers in this task can
	// assume. This role allows your application code to access other Amazon Web
	// Services services securely.
	//
	// The task role is different from the execution role. While the execution role is
	// used by the Amazon ECS agent to set up the task, the task role is used by your
	// application code running inside the container to make Amazon Web Services API
	// calls. If your application doesn't need to access Amazon Web Services services,
	// you can omit this parameter.
	TaskRoleArn *string

	noSmithyDocumentSerde
}

type CreateExpressGatewayServiceOutput struct {

	// The full description of your Express service following the create operation.
	Service *types.ECSExpressGatewayService

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateExpressGatewayServiceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateExpressGatewayService{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateExpressGatewayService{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateExpressGatewayService"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateExpressGatewayServiceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateExpressGatewayService(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateExpressGatewayService(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateExpressGatewayService",
	}
}
