// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Dynamically increases the number of replicas in a Valkey or Redis OSS (cluster
// mode disabled) replication group or the number of replica nodes in one or more
// node groups (shards) of a Valkey or Redis OSS (cluster mode enabled) replication
// group. This operation is performed with no cluster down time.
func (c *Client) IncreaseReplicaCount(ctx context.Context, params *IncreaseReplicaCountInput, optFns ...func(*Options)) (*IncreaseReplicaCountOutput, error) {
	if params == nil {
		params = &IncreaseReplicaCountInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "IncreaseReplicaCount", params, optFns, c.addOperationIncreaseReplicaCountMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*IncreaseReplicaCountOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type IncreaseReplicaCountInput struct {

	// If True , the number of replica nodes is increased immediately.
	// ApplyImmediately=False is not currently supported.
	//
	// This member is required.
	ApplyImmediately *bool

	// The id of the replication group to which you want to add replica nodes.
	//
	// This member is required.
	ReplicationGroupId *string

	// The number of read replica nodes you want at the completion of this operation.
	// For Valkey or Redis OSS (cluster mode disabled) replication groups, this is the
	// number of replica nodes in the replication group. For Valkey or Redis OSS
	// (cluster mode enabled) replication groups, this is the number of replica nodes
	// in each of the replication group's node groups.
	NewReplicaCount *int32

	// A list of ConfigureShard objects that can be used to configure each shard in a
	// Valkey or Redis OSS (cluster mode enabled) replication group. The ConfigureShard
	// has three members: NewReplicaCount , NodeGroupId , and
	// PreferredAvailabilityZones .
	ReplicaConfiguration []types.ConfigureShard

	noSmithyDocumentSerde
}

type IncreaseReplicaCountOutput struct {

	// Contains all of the attributes of a specific Valkey or Redis OSS replication
	// group.
	ReplicationGroup *types.ReplicationGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationIncreaseReplicaCountMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpIncreaseReplicaCount{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpIncreaseReplicaCount{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "IncreaseReplicaCount"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpIncreaseReplicaCountValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opIncreaseReplicaCount(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opIncreaseReplicaCount(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "IncreaseReplicaCount",
	}
}
