// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticsearchservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticsearchservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists available reserved Elasticsearch instance offerings.
func (c *Client) DescribeReservedElasticsearchInstanceOfferings(ctx context.Context, params *DescribeReservedElasticsearchInstanceOfferingsInput, optFns ...func(*Options)) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	if params == nil {
		params = &DescribeReservedElasticsearchInstanceOfferingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeReservedElasticsearchInstanceOfferings", params, optFns, c.addOperationDescribeReservedElasticsearchInstanceOfferingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeReservedElasticsearchInstanceOfferingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for parameters to DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsInput struct {

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults int32

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	ReservedElasticsearchInstanceOfferingId *string

	noSmithyDocumentSerde
}

// Container for results from DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsOutput struct {

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string

	// List of reserved Elasticsearch instance offerings
	ReservedElasticsearchInstanceOfferings []types.ReservedElasticsearchInstanceOffering

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeReservedElasticsearchInstanceOfferingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeReservedElasticsearchInstanceOfferings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeReservedElasticsearchInstanceOfferings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeReservedElasticsearchInstanceOfferings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeReservedElasticsearchInstanceOfferings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeReservedElasticsearchInstanceOfferingsPaginatorOptions is the paginator
// options for DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsPaginatorOptions struct {
	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeReservedElasticsearchInstanceOfferingsPaginator is a paginator for
// DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsPaginator struct {
	options   DescribeReservedElasticsearchInstanceOfferingsPaginatorOptions
	client    DescribeReservedElasticsearchInstanceOfferingsAPIClient
	params    *DescribeReservedElasticsearchInstanceOfferingsInput
	nextToken *string
	firstPage bool
}

// NewDescribeReservedElasticsearchInstanceOfferingsPaginator returns a new
// DescribeReservedElasticsearchInstanceOfferingsPaginator
func NewDescribeReservedElasticsearchInstanceOfferingsPaginator(client DescribeReservedElasticsearchInstanceOfferingsAPIClient, params *DescribeReservedElasticsearchInstanceOfferingsInput, optFns ...func(*DescribeReservedElasticsearchInstanceOfferingsPaginatorOptions)) *DescribeReservedElasticsearchInstanceOfferingsPaginator {
	if params == nil {
		params = &DescribeReservedElasticsearchInstanceOfferingsInput{}
	}

	options := DescribeReservedElasticsearchInstanceOfferingsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeReservedElasticsearchInstanceOfferingsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeReservedElasticsearchInstanceOfferingsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeReservedElasticsearchInstanceOfferings page.
func (p *DescribeReservedElasticsearchInstanceOfferingsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeReservedElasticsearchInstanceOfferings(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeReservedElasticsearchInstanceOfferingsAPIClient is a client that
// implements the DescribeReservedElasticsearchInstanceOfferings operation.
type DescribeReservedElasticsearchInstanceOfferingsAPIClient interface {
	DescribeReservedElasticsearchInstanceOfferings(context.Context, *DescribeReservedElasticsearchInstanceOfferingsInput, ...func(*Options)) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error)
}

var _ DescribeReservedElasticsearchInstanceOfferingsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeReservedElasticsearchInstanceOfferings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeReservedElasticsearchInstanceOfferings",
	}
}
