// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all available details about the instance fleets in a cluster.
//
// The instance fleet configuration is available only in Amazon EMR releases 4.8.0
// and later, excluding 5.0.x versions.
func (c *Client) ListInstanceFleets(ctx context.Context, params *ListInstanceFleetsInput, optFns ...func(*Options)) (*ListInstanceFleetsOutput, error) {
	if params == nil {
		params = &ListInstanceFleetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInstanceFleets", params, optFns, c.addOperationListInstanceFleetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInstanceFleetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInstanceFleetsInput struct {

	// The unique identifier of the cluster.
	//
	// This member is required.
	ClusterId *string

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string

	noSmithyDocumentSerde
}

type ListInstanceFleetsOutput struct {

	// The list of instance fleets for the cluster and given filters.
	InstanceFleets []types.InstanceFleet

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInstanceFleetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListInstanceFleets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListInstanceFleets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInstanceFleets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListInstanceFleetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInstanceFleets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInstanceFleetsPaginatorOptions is the paginator options for
// ListInstanceFleets
type ListInstanceFleetsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInstanceFleetsPaginator is a paginator for ListInstanceFleets
type ListInstanceFleetsPaginator struct {
	options   ListInstanceFleetsPaginatorOptions
	client    ListInstanceFleetsAPIClient
	params    *ListInstanceFleetsInput
	nextToken *string
	firstPage bool
}

// NewListInstanceFleetsPaginator returns a new ListInstanceFleetsPaginator
func NewListInstanceFleetsPaginator(client ListInstanceFleetsAPIClient, params *ListInstanceFleetsInput, optFns ...func(*ListInstanceFleetsPaginatorOptions)) *ListInstanceFleetsPaginator {
	if params == nil {
		params = &ListInstanceFleetsInput{}
	}

	options := ListInstanceFleetsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInstanceFleetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInstanceFleetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInstanceFleets page.
func (p *ListInstanceFleetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInstanceFleetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInstanceFleets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInstanceFleetsAPIClient is a client that implements the ListInstanceFleets
// operation.
type ListInstanceFleetsAPIClient interface {
	ListInstanceFleets(context.Context, *ListInstanceFleetsInput, ...func(*Options)) (*ListInstanceFleetsOutput, error)
}

var _ ListInstanceFleetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInstanceFleets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInstanceFleets",
	}
}
