// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This API works with the following fleet types: EC2 (FleetIQ)
//
// Locates an available game server and temporarily reserves it to host gameplay
// and players. This operation is called from a game client or client service (such
// as a matchmaker) to request hosting resources for a new game session. In
// response, Amazon GameLift Servers FleetIQ locates an available game server,
// places it in CLAIMED status for 60 seconds, and returns connection information
// that players can use to connect to the game server.
//
// To claim a game server, identify a game server group. You can also specify a
// game server ID, although this approach bypasses Amazon GameLift Servers FleetIQ
// placement optimization. Optionally, include game data to pass to the game server
// at the start of a game session, such as a game map or player information. Add
// filter options to further restrict how a game server is chosen, such as only
// allowing game servers on ACTIVE instances to be claimed.
//
// When a game server is successfully claimed, connection information is returned.
// A claimed game server's utilization status remains AVAILABLE while the claim
// status is set to CLAIMED for up to 60 seconds. This time period gives the game
// server time to update its status to UTILIZED after players join. If the game
// server's status is not updated within 60 seconds, the game server reverts to
// unclaimed status and is available to be claimed by another request. The claim
// time period is a fixed value and is not configurable.
//
// If you try to claim a specific game server, this request will fail in the
// following cases:
//
//   - If the game server utilization status is UTILIZED .
//
//   - If the game server claim status is CLAIMED .
//
//   - If the game server is running on an instance in DRAINING status and the
//     provided filter option does not allow placing on DRAINING instances.
//
// # Learn more
//
// [Amazon GameLift Servers FleetIQ Guide]
//
// [Amazon GameLift Servers FleetIQ Guide]: https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html
func (c *Client) ClaimGameServer(ctx context.Context, params *ClaimGameServerInput, optFns ...func(*Options)) (*ClaimGameServerOutput, error) {
	if params == nil {
		params = &ClaimGameServerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ClaimGameServer", params, optFns, c.addOperationClaimGameServerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ClaimGameServerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ClaimGameServerInput struct {

	// A unique identifier for the game server group where the game server is running.
	// If you are not specifying a game server to claim, this value identifies where
	// you want Amazon GameLift Servers FleetIQ to look for an available game server to
	// claim.
	//
	// This member is required.
	GameServerGroupName *string

	// Object that restricts how a claimed game server is chosen.
	FilterOption *types.ClaimFilterOption

	// A set of custom game server properties, formatted as a single string value.
	// This data is passed to a game client or service when it requests information on
	// game servers.
	GameServerData *string

	// A custom string that uniquely identifies the game server to claim. If this
	// parameter is left empty, Amazon GameLift Servers FleetIQ searches for an
	// available game server in the specified game server group.
	GameServerId *string

	noSmithyDocumentSerde
}

type ClaimGameServerOutput struct {

	// Object that describes the newly claimed game server.
	GameServer *types.GameServer

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationClaimGameServerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpClaimGameServer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpClaimGameServer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ClaimGameServer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpClaimGameServerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opClaimGameServer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opClaimGameServer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ClaimGameServer",
	}
}
