// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This API works with the following fleet types: Container
//
// Creates a managed fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances
// to host your containerized game servers. Use this operation to define how to
// deploy a container architecture onto each fleet instance and configure fleet
// settings. You can create a container fleet in any Amazon Web Services Regions
// that Amazon GameLift Servers supports for multi-location fleets. A container
// fleet can be deployed to a single location or multiple locations. Container
// fleets are deployed with Amazon Linux 2023 as the instance operating system.
//
// Define the fleet's container architecture using container group definitions.
// Each fleet can have one of the following container group types:
//
//   - The game server container group runs your game server build and dependent
//     software. Amazon GameLift Servers deploys one or more replicas of this container
//     group to each fleet instance. The number of replicas depends on the computing
//     capabilities of the fleet instance in use.
//
//   - An optional per-instance container group might be used to run other
//     software that only needs to run once per instance, such as background services,
//     logging, or test processes. One per-instance container group is deployed to each
//     fleet instance.
//
// Each container group can include the definition for one or more containers. A
// container definition specifies a container image that is stored in an Amazon
// Elastic Container Registry (Amazon ECR) public or private repository.
//
// # Request options
//
// Use this operation to make the following types of requests. Most fleet settings
// have default values, so you can create a working fleet with a minimal
// configuration and default values, which you can customize later.
//
//   - Create a fleet with no container groups. You can configure a container
//     fleet and then add container group definitions later. In this scenario, no fleet
//     instances are deployed, and the fleet can't host game sessions until you add a
//     game server container group definition. Provide the following required parameter
//     values:
//
//   - FleetRoleArn
//
//   - Create a fleet with a game server container group. Provide the following
//     required parameter values:
//
//   - FleetRoleArn
//
//   - GameServerContainerGroupDefinitionName
//
//   - Create a fleet with a game server container group and a per-instance
//     container group. Provide the following required parameter values:
//
//   - FleetRoleArn
//
//   - GameServerContainerGroupDefinitionName
//
//   - PerInstanceContainerGroupDefinitionName
//
// # Results
//
// If successful, this operation creates a new container fleet resource, places it
// in PENDING status, and initiates the [fleet creation workflow]. For fleets with container groups, this
// workflow starts a fleet deployment and transitions the status to ACTIVE . Fleets
// without a container group are placed in CREATED status.
//
// You can update most of the properties of a fleet, including container group
// definitions, and deploy the update across all fleet instances. Use [UpdateContainerFleet]to deploy a
// new game server version update across the container fleet.
//
// A managed fleet's runtime environment depends on the Amazon Machine Image (AMI)
// version it uses. When a new fleet is created, Amazon GameLift Servers assigns
// the latest available AMI version to the fleet, and all compute instances in that
// fleet are deployed with that version. To update the AMI version, you must create
// a new fleet. As a best practice, we recommend replacing your managed fleets
// every 30 days to maintain a secure and up-to-date runtime environment for your
// hosted game servers. For guidance, see [Security best practices for Amazon GameLift Servers].
//
// [fleet creation workflow]: https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow
// [Security best practices for Amazon GameLift Servers]: https://docs.aws.amazon.com/gameliftservers/latest/developerguide/security-best-practices.html
// [UpdateContainerFleet]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerFleet.html
func (c *Client) CreateContainerFleet(ctx context.Context, params *CreateContainerFleetInput, optFns ...func(*Options)) (*CreateContainerFleetOutput, error) {
	if params == nil {
		params = &CreateContainerFleetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateContainerFleet", params, optFns, c.addOperationCreateContainerFleetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateContainerFleetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateContainerFleetInput struct {

	// The unique identifier for an Identity and Access Management (IAM) role with
	// permissions to run your containers on resources that are managed by Amazon
	// GameLift Servers. Use an IAM service role with the GameLiftContainerFleetPolicy
	// managed policy attached. For more information, see [Set up an IAM service role]. You can't change this
	// fleet property after the fleet is created.
	//
	// IAM role ARN values use the following pattern: arn:aws:iam::[Amazon Web
	// Services account]:role/[role name] .
	//
	// [Set up an IAM service role]: https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html
	//
	// This member is required.
	FleetRoleArn *string

	// Indicates whether to use On-Demand or Spot instances for this fleet. Learn more
	// about when to use [On-Demand versus Spot Instances]. This fleet property can't be changed after the fleet is
	// created.
	//
	// By default, this property is set to ON_DEMAND .
	//
	// You can't update this fleet property later.
	//
	// [On-Demand versus Spot Instances]: https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot
	BillingType types.ContainerFleetBillingType

	// A meaningful description of the container fleet.
	Description *string

	// A container group definition resource that describes how to deploy containers
	// with your game server build and support software onto each fleet instance. You
	// can specify the container group definition's name to use the latest version.
	// Alternatively, provide an ARN value with a specific version number.
	//
	// Create a container group definition by calling [CreateContainerGroupDefinition]. This operation creates a [ContainerGroupDefinition]
	// resource.
	//
	// [ContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html
	// [CreateContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html
	GameServerContainerGroupDefinitionName *string

	// The number of times to replicate the game server container group on each fleet
	// instance.
	//
	// By default, Amazon GameLift Servers calculates the maximum number of game
	// server container groups that can fit on each instance. This calculation is based
	// on the CPU and memory resources of the fleet's instance type). To use the
	// calculated maximum, don't set this parameter. If you set this number manually,
	// Amazon GameLift Servers uses your value as long as it's less than the calculated
	// maximum.
	GameServerContainerGroupsPerInstance *int32

	// A policy that limits the number of game sessions that each individual player
	// can create on instances in this fleet. The limit applies for a specified span of
	// time.
	GameSessionCreationLimitPolicy *types.GameSessionCreationLimitPolicy

	// The set of port numbers to open on each fleet instance. A fleet's connection
	// ports map to container ports that are configured in the fleet's container group
	// definitions.
	//
	// By default, Amazon GameLift Servers calculates an optimal port range based on
	// your fleet configuration. To use the calculated range, don't set this parameter.
	// The values are:
	//
	//   - Port range: 4192 to a number calculated based on your fleet configuration.
	//   Amazon GameLift Servers uses the following formula: 4192 + [# of game server
	//   container groups per fleet instance] * [# of container ports in the game server
	//   container group definition] + [# of container ports in the game server container
	//   group definition]
	//
	// You can also choose to manually set this parameter. When manually setting this
	// parameter, you must use port numbers that match the fleet's inbound permissions
	// port range.
	//
	// If you set values manually, Amazon GameLift Servers no longer calculates a port
	// range for you, even if you later remove the manual settings.
	InstanceConnectionPortRange *types.ConnectionPortRange

	// The IP address ranges and port settings that allow inbound traffic to access
	// game server processes and other processes on this fleet. As a best practice,
	// when remotely accessing a fleet instance, we recommend opening ports only when
	// you need them and closing them when you're finished.
	//
	// By default, Amazon GameLift Servers calculates an optimal port range based on
	// your fleet configuration. To use the calculated range, don't set this parameter.
	// The values are:
	//
	//   - Protocol: UDP
	//
	//   - Port range: 4192 to a number calculated based on your fleet configuration.
	//   Amazon GameLift Servers uses the following formula: 4192 + [# of game server
	//   container groups per fleet instance] * [# of container ports in the game server
	//   container group definition] + [# of container ports in the game server container
	//   group definition]
	//
	// You can also choose to manually set this parameter. When manually setting this
	// parameter, you must use port numbers that match the fleet's connection port
	// range.
	//
	// If you set values manually, Amazon GameLift Servers no longer calculates a port
	// range for you, even if you later remove the manual settings.
	InstanceInboundPermissions []types.IpPermission

	// The Amazon EC2 instance type to use for all instances in the fleet. For
	// multi-location fleets, the instance type must be available in the home region
	// and all remote locations. Instance type determines the computing resources and
	// processing power that's available to host your game servers. This includes
	// including CPU, memory, storage, and networking capacity.
	//
	// By default, Amazon GameLift Servers selects an instance type that fits the
	// needs of your container groups and is available in all selected fleet locations.
	// You can also choose to manually set this parameter. See [Amazon Elastic Compute Cloud Instance Types]for detailed
	// descriptions of Amazon EC2 instance types.
	//
	// You can't update this fleet property later.
	//
	// [Amazon Elastic Compute Cloud Instance Types]: http://aws.amazon.com/ec2/instance-types/
	InstanceType *string

	// A set of locations to deploy container fleet instances to. You can add any
	// Amazon Web Services Region or Local Zone that's supported by Amazon GameLift
	// Servers. Provide a list of one or more Amazon Web Services Region codes, such as
	// us-west-2 , or Local Zone names. Also include the fleet's home Region, which is
	// the Amazon Web Services Region where the fleet is created. For a list of
	// supported Regions and Local Zones, see [Amazon GameLift Servers service locations]for managed hosting.
	//
	// [Amazon GameLift Servers service locations]: https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html
	Locations []types.LocationConfiguration

	// A method for collecting container logs for the fleet. Amazon GameLift Servers
	// saves all standard output for each container in logs, including game session
	// logs. You can select from the following methods:
	//
	//   - CLOUDWATCH -- Send logs to an Amazon CloudWatch log group that you define.
	//   Each container emits a log stream, which is organized in the log group.
	//
	//   - S3 -- Store logs in an Amazon S3 bucket that you define.
	//
	//   - NONE -- Don't collect container logs.
	//
	// By default, this property is set to CLOUDWATCH .
	//
	// Amazon GameLift Servers requires permissions to send logs other Amazon Web
	// Services services in your account. These permissions are included in the IAM
	// fleet role for this container fleet (see FleetRoleArn) .
	LogConfiguration *types.LogConfiguration

	// The name of an Amazon Web Services CloudWatch metric group to add this fleet
	// to. You can use a metric group to aggregate metrics for multiple fleets. You can
	// specify an existing metric group name or use a new name to create a new metric
	// group. Each fleet can have only one metric group, but you can change this value
	// at any time.
	MetricGroups []string

	// Determines whether Amazon GameLift Servers can shut down game sessions on the
	// fleet that are actively running and hosting players. Amazon GameLift Servers
	// might prompt an instance shutdown when scaling down fleet capacity or when
	// retiring unhealthy instances. You can also set game session protection for
	// individual game sessions using UpdateGameSession.
	//
	//   - NoProtection -- Game sessions can be shut down during active gameplay.
	//
	//   - FullProtection -- Game sessions in ACTIVE status can't be shut down.
	//
	// By default, this property is set to NoProtection .
	NewGameSessionProtectionPolicy types.ProtectionPolicy

	// The name of a container group definition resource that describes a set of
	// axillary software. A fleet instance has one process for executables in this
	// container group. A per-instance container group is optional. You can update the
	// fleet to add or remove a per-instance container group at any time. You can
	// specify the container group definition's name to use the latest version.
	// Alternatively, provide an ARN value with a specific version number.
	//
	// Create a container group definition by calling [https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html]. This operation creates a [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html]
	// resource.
	//
	// [https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html
	// [https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html
	PerInstanceContainerGroupDefinitionName *string

	// A list of labels to assign to the new fleet resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources are
	// useful for resource management, access management and cost allocation. For more
	// information, see [Tagging Amazon Web Services Resources]in the Amazon Web Services General Reference.
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateContainerFleetOutput struct {

	// The properties for the new container fleet, including current status. All
	// fleets are initially placed in PENDING status.
	ContainerFleet *types.ContainerFleet

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateContainerFleetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateContainerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateContainerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateContainerFleet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateContainerFleetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateContainerFleet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateContainerFleet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateContainerFleet",
	}
}
