// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of all Amazon GameLift Streams stream groups that are
// associated with the Amazon Web Services account in use. This operation returns
// stream groups in all statuses, in no particular order. You can paginate the
// results as needed.
func (c *Client) ListStreamGroups(ctx context.Context, params *ListStreamGroupsInput, optFns ...func(*Options)) (*ListStreamGroupsOutput, error) {
	if params == nil {
		params = &ListStreamGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStreamGroups", params, optFns, c.addOperationListStreamGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStreamGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStreamGroupsInput struct {

	// The number of results to return. Use this parameter with NextToken to return
	// results in sequential pages. Default value is 25 .
	MaxResults *int32

	// A token that marks the start of the next set of results. Use this token when
	// you retrieve results as sequential pages. To get the first page of results, omit
	// a token value. To get the remaining pages, provide the token returned with the
	// previous result set.
	NextToken *string

	noSmithyDocumentSerde
}

type ListStreamGroupsOutput struct {

	// A collection of Amazon GameLift Streams stream groups that are associated with
	// the Amazon Web Services account in use. Each item includes stream group metadata
	// and status, but doesn't include capacity information.
	Items []types.StreamGroupSummary

	// A token that marks the start of the next sequential page of results. If an
	// operation doesn't return a token, you've reached the end of the list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStreamGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListStreamGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListStreamGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStreamGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStreamGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListStreamGroupsPaginatorOptions is the paginator options for ListStreamGroups
type ListStreamGroupsPaginatorOptions struct {
	// The number of results to return. Use this parameter with NextToken to return
	// results in sequential pages. Default value is 25 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStreamGroupsPaginator is a paginator for ListStreamGroups
type ListStreamGroupsPaginator struct {
	options   ListStreamGroupsPaginatorOptions
	client    ListStreamGroupsAPIClient
	params    *ListStreamGroupsInput
	nextToken *string
	firstPage bool
}

// NewListStreamGroupsPaginator returns a new ListStreamGroupsPaginator
func NewListStreamGroupsPaginator(client ListStreamGroupsAPIClient, params *ListStreamGroupsInput, optFns ...func(*ListStreamGroupsPaginatorOptions)) *ListStreamGroupsPaginator {
	if params == nil {
		params = &ListStreamGroupsInput{}
	}

	options := ListStreamGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStreamGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStreamGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStreamGroups page.
func (p *ListStreamGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStreamGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStreamGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStreamGroupsAPIClient is a client that implements the ListStreamGroups
// operation.
type ListStreamGroupsAPIClient interface {
	ListStreamGroups(context.Context, *ListStreamGroupsInput, ...func(*Options)) (*ListStreamGroupsOutput, error)
}

var _ ListStreamGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStreamGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStreamGroups",
	}
}
