// Code generated by smithy-go-codegen DO NOT EDIT.

package geoplaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geoplaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Geocode converts a textual address or place into geographic coordinates. You
// can obtain geographic coordinates, address component, and other related
// information. It supports flexible queries, including free-form text or
// structured queries with components like street names, postal codes, and regions.
// The Geocode API can also provide additional features such as time zone
// information and the inclusion of political views.
func (c *Client) Geocode(ctx context.Context, params *GeocodeInput, optFns ...func(*Options)) (*GeocodeOutput, error) {
	if params == nil {
		params = &GeocodeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Geocode", params, optFns, c.addOperationGeocodeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GeocodeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GeocodeInput struct {

	// A list of optional additional parameters, such as time zone, that can be
	// requested for each result.
	AdditionalFeatures []types.GeocodeAdditionalFeature

	// The position, in longitude and latitude, that the results should be close to.
	// Typically, place results returned are ranked higher the closer they are to this
	// position. Stored in [lng, lat] and in the WSG84 format.
	//
	// The fields BiasPosition , FilterBoundingBox , and FilterCircle are mutually
	// exclusive.
	BiasPosition []float64

	// A structure which contains a set of inclusion/exclusion properties that results
	// must possess in order to be returned as a result.
	Filter *types.GeocodeFilter

	// Indicates if the results will be stored. Defaults to SingleUse , if left empty.
	//
	// Storing the response of an Geocode query is required to comply with service
	// terms, but charged at a higher cost per request. Please review the [user agreement]and [service pricing structure] to
	// determine the correct setting for your use case.
	//
	// [service pricing structure]: https://aws.amazon.com/location/pricing/
	// [user agreement]: https://aws.amazon.com/location/sla/
	IntendedUse types.GeocodeIntendedUse

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// A list of [BCP 47] compliant language codes for the results to be rendered in. If there
	// is no data for the result in the requested language, data will be returned in
	// the default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// An optional limit for the number of results returned in a single call.
	MaxResults *int32

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// A structured free text query allows you to search for places by the name or
	// text representation of specific properties of the place.
	QueryComponents *types.GeocodeQueryComponents

	// The free-form text query to match addresses against. This is usually a
	// partially typed address from an end user in an address box or form.
	//
	// The fields QueryText , and QueryID are mutually exclusive.
	QueryText *string

	noSmithyDocumentSerde
}

type GeocodeOutput struct {

	// The pricing bucket for which the query is charged at.
	//
	// For more information on pricing, please visit [Amazon Location Service Pricing].
	//
	// [Amazon Location Service Pricing]: https://aws.amazon.com/location/pricing/
	//
	// This member is required.
	PricingBucket *string

	// List of places or results returned for a query.
	ResultItems []types.GeocodeResultItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGeocodeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGeocode{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGeocode{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Geocode"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGeocode(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGeocode(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Geocode",
	}
}
