// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves all catalogs defined in a catalog in the Glue Data Catalog. For a
// Redshift-federated catalog use case, this operation returns the list of catalogs
// mapped to Redshift databases in the Redshift namespace catalog.
func (c *Client) GetCatalogs(ctx context.Context, params *GetCatalogsInput, optFns ...func(*Options)) (*GetCatalogsOutput, error) {
	if params == nil {
		params = &GetCatalogsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCatalogs", params, optFns, c.addOperationGetCatalogsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCatalogsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCatalogsInput struct {

	// Whether to list the default catalog in the account and region in the response.
	// Defaults to false . When true and ParentCatalogId = NULL | Amazon Web Services
	// Account ID , all catalogs and the default catalog are enumerated in the response.
	//
	// When the ParentCatalogId is not equal to null, and this attribute is passed as
	// false or true , an InvalidInputException is thrown.
	IncludeRoot *bool

	// The maximum number of catalogs to return in one response.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	// The ID of the parent catalog in which the catalog resides. If none is provided,
	// the Amazon Web Services Account Number is used by default.
	ParentCatalogId *string

	// Whether to list all catalogs across the catalog hierarchy, starting from the
	// ParentCatalogId . Defaults to false . When true , all catalog objects in the
	// ParentCatalogID hierarchy are enumerated in the response.
	Recursive bool

	noSmithyDocumentSerde
}

type GetCatalogsOutput struct {

	// An array of Catalog objects. A list of Catalog objects from the specified
	// parent catalog.
	//
	// This member is required.
	CatalogList []types.Catalog

	// A continuation token for paginating the returned list of tokens, returned if
	// the current segment of the list is not the last.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCatalogsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetCatalogs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetCatalogs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCatalogs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCatalogs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCatalogs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCatalogs",
	}
}
